package com.commercetools.graphql.api.types;

import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.Objects;

public class TransitionOrderCustomLineItemState {
  private String customLineItemId;

  private String customLineItemKey;

  private Long quantity;

  private ResourceIdentifierInput fromState;

  private ResourceIdentifierInput toState;

  private OffsetDateTime actualTransitionDate;

  public TransitionOrderCustomLineItemState() {
  }

  public TransitionOrderCustomLineItemState(String customLineItemId, String customLineItemKey,
      Long quantity, ResourceIdentifierInput fromState, ResourceIdentifierInput toState,
      OffsetDateTime actualTransitionDate) {
    this.customLineItemId = customLineItemId;
    this.customLineItemKey = customLineItemKey;
    this.quantity = quantity;
    this.fromState = fromState;
    this.toState = toState;
    this.actualTransitionDate = actualTransitionDate;
  }

  public String getCustomLineItemId() {
    return customLineItemId;
  }

  public void setCustomLineItemId(String customLineItemId) {
    this.customLineItemId = customLineItemId;
  }

  public String getCustomLineItemKey() {
    return customLineItemKey;
  }

  public void setCustomLineItemKey(String customLineItemKey) {
    this.customLineItemKey = customLineItemKey;
  }

  public Long getQuantity() {
    return quantity;
  }

  public void setQuantity(Long quantity) {
    this.quantity = quantity;
  }

  public ResourceIdentifierInput getFromState() {
    return fromState;
  }

  public void setFromState(ResourceIdentifierInput fromState) {
    this.fromState = fromState;
  }

  public ResourceIdentifierInput getToState() {
    return toState;
  }

  public void setToState(ResourceIdentifierInput toState) {
    this.toState = toState;
  }

  public OffsetDateTime getActualTransitionDate() {
    return actualTransitionDate;
  }

  public void setActualTransitionDate(OffsetDateTime actualTransitionDate) {
    this.actualTransitionDate = actualTransitionDate;
  }

  @Override
  public String toString() {
    return "TransitionOrderCustomLineItemState{customLineItemId='" + customLineItemId + "', customLineItemKey='" + customLineItemKey + "', quantity='" + quantity + "', fromState='" + fromState + "', toState='" + toState + "', actualTransitionDate='" + actualTransitionDate + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    TransitionOrderCustomLineItemState that = (TransitionOrderCustomLineItemState) o;
    return Objects.equals(customLineItemId, that.customLineItemId) &&
        Objects.equals(customLineItemKey, that.customLineItemKey) &&
        Objects.equals(quantity, that.quantity) &&
        Objects.equals(fromState, that.fromState) &&
        Objects.equals(toState, that.toState) &&
        Objects.equals(actualTransitionDate, that.actualTransitionDate);
  }

  @Override
  public int hashCode() {
    return Objects.hash(customLineItemId, customLineItemKey, quantity, fromState, toState, actualTransitionDate);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String customLineItemId;

    private String customLineItemKey;

    private Long quantity;

    private ResourceIdentifierInput fromState;

    private ResourceIdentifierInput toState;

    private OffsetDateTime actualTransitionDate;

    public TransitionOrderCustomLineItemState build() {
      TransitionOrderCustomLineItemState result = new TransitionOrderCustomLineItemState();
      result.customLineItemId = this.customLineItemId;
      result.customLineItemKey = this.customLineItemKey;
      result.quantity = this.quantity;
      result.fromState = this.fromState;
      result.toState = this.toState;
      result.actualTransitionDate = this.actualTransitionDate;
      return result;
    }

    public Builder customLineItemId(String customLineItemId) {
      this.customLineItemId = customLineItemId;
      return this;
    }

    public Builder customLineItemKey(String customLineItemKey) {
      this.customLineItemKey = customLineItemKey;
      return this;
    }

    public Builder quantity(Long quantity) {
      this.quantity = quantity;
      return this;
    }

    public Builder fromState(ResourceIdentifierInput fromState) {
      this.fromState = fromState;
      return this;
    }

    public Builder toState(ResourceIdentifierInput toState) {
      this.toState = toState;
      return this;
    }

    public Builder actualTransitionDate(OffsetDateTime actualTransitionDate) {
      this.actualTransitionDate = actualTransitionDate;
      return this;
    }
  }
}
