package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class TransitionStagedOrderCustomLineItemStateOutput implements com.commercetools.graphql.api.types.StagedOrderUpdateActionOutput {
  private String type;

  private String customLineItemId;

  private String customLineItemKey;

  private Long quantity;

  private ResourceIdentifier fromStateResId;

  private ResourceIdentifier toStateResId;

  private OffsetDateTime actualTransitionDate;

  public TransitionStagedOrderCustomLineItemStateOutput() {
  }

  public TransitionStagedOrderCustomLineItemStateOutput(String type, String customLineItemId,
      String customLineItemKey, Long quantity, ResourceIdentifier fromStateResId,
      ResourceIdentifier toStateResId, OffsetDateTime actualTransitionDate) {
    this.type = type;
    this.customLineItemId = customLineItemId;
    this.customLineItemKey = customLineItemKey;
    this.quantity = quantity;
    this.fromStateResId = fromStateResId;
    this.toStateResId = toStateResId;
    this.actualTransitionDate = actualTransitionDate;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public String getCustomLineItemId() {
    return customLineItemId;
  }

  public void setCustomLineItemId(String customLineItemId) {
    this.customLineItemId = customLineItemId;
  }

  public String getCustomLineItemKey() {
    return customLineItemKey;
  }

  public void setCustomLineItemKey(String customLineItemKey) {
    this.customLineItemKey = customLineItemKey;
  }

  public Long getQuantity() {
    return quantity;
  }

  public void setQuantity(Long quantity) {
    this.quantity = quantity;
  }

  public ResourceIdentifier getFromStateResId() {
    return fromStateResId;
  }

  public void setFromStateResId(ResourceIdentifier fromStateResId) {
    this.fromStateResId = fromStateResId;
  }

  public ResourceIdentifier getToStateResId() {
    return toStateResId;
  }

  public void setToStateResId(ResourceIdentifier toStateResId) {
    this.toStateResId = toStateResId;
  }

  public OffsetDateTime getActualTransitionDate() {
    return actualTransitionDate;
  }

  public void setActualTransitionDate(OffsetDateTime actualTransitionDate) {
    this.actualTransitionDate = actualTransitionDate;
  }

  @Override
  public String toString() {
    return "TransitionStagedOrderCustomLineItemStateOutput{type='" + type + "', customLineItemId='" + customLineItemId + "', customLineItemKey='" + customLineItemKey + "', quantity='" + quantity + "', fromStateResId='" + fromStateResId + "', toStateResId='" + toStateResId + "', actualTransitionDate='" + actualTransitionDate + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    TransitionStagedOrderCustomLineItemStateOutput that = (TransitionStagedOrderCustomLineItemStateOutput) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(customLineItemId, that.customLineItemId) &&
        Objects.equals(customLineItemKey, that.customLineItemKey) &&
        Objects.equals(quantity, that.quantity) &&
        Objects.equals(fromStateResId, that.fromStateResId) &&
        Objects.equals(toStateResId, that.toStateResId) &&
        Objects.equals(actualTransitionDate, that.actualTransitionDate);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, customLineItemId, customLineItemKey, quantity, fromStateResId, toStateResId, actualTransitionDate);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    private String customLineItemId;

    private String customLineItemKey;

    private Long quantity;

    private ResourceIdentifier fromStateResId;

    private ResourceIdentifier toStateResId;

    private OffsetDateTime actualTransitionDate;

    public TransitionStagedOrderCustomLineItemStateOutput build() {
      TransitionStagedOrderCustomLineItemStateOutput result = new TransitionStagedOrderCustomLineItemStateOutput();
      result.type = this.type;
      result.customLineItemId = this.customLineItemId;
      result.customLineItemKey = this.customLineItemKey;
      result.quantity = this.quantity;
      result.fromStateResId = this.fromStateResId;
      result.toStateResId = this.toStateResId;
      result.actualTransitionDate = this.actualTransitionDate;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder customLineItemId(String customLineItemId) {
      this.customLineItemId = customLineItemId;
      return this;
    }

    public Builder customLineItemKey(String customLineItemKey) {
      this.customLineItemKey = customLineItemKey;
      return this;
    }

    public Builder quantity(Long quantity) {
      this.quantity = quantity;
      return this;
    }

    public Builder fromStateResId(ResourceIdentifier fromStateResId) {
      this.fromStateResId = fromStateResId;
      return this;
    }

    public Builder toStateResId(ResourceIdentifier toStateResId) {
      this.toStateResId = toStateResId;
      return this;
    }

    public Builder actualTransitionDate(OffsetDateTime actualTransitionDate) {
      this.actualTransitionDate = actualTransitionDate;
      return this;
    }
  }
}
