package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class TransitionStagedOrderLineItemStateOutput implements com.commercetools.graphql.api.types.StagedOrderUpdateActionOutput {
  private String type;

  private String lineItemId;

  private String lineItemKey;

  private Long quantity;

  private ResourceIdentifier fromStateResId;

  private ResourceIdentifier toStateResId;

  private OffsetDateTime actualTransitionDate;

  public TransitionStagedOrderLineItemStateOutput() {
  }

  public TransitionStagedOrderLineItemStateOutput(String type, String lineItemId,
      String lineItemKey, Long quantity, ResourceIdentifier fromStateResId,
      ResourceIdentifier toStateResId, OffsetDateTime actualTransitionDate) {
    this.type = type;
    this.lineItemId = lineItemId;
    this.lineItemKey = lineItemKey;
    this.quantity = quantity;
    this.fromStateResId = fromStateResId;
    this.toStateResId = toStateResId;
    this.actualTransitionDate = actualTransitionDate;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public String getLineItemId() {
    return lineItemId;
  }

  public void setLineItemId(String lineItemId) {
    this.lineItemId = lineItemId;
  }

  public String getLineItemKey() {
    return lineItemKey;
  }

  public void setLineItemKey(String lineItemKey) {
    this.lineItemKey = lineItemKey;
  }

  public Long getQuantity() {
    return quantity;
  }

  public void setQuantity(Long quantity) {
    this.quantity = quantity;
  }

  public ResourceIdentifier getFromStateResId() {
    return fromStateResId;
  }

  public void setFromStateResId(ResourceIdentifier fromStateResId) {
    this.fromStateResId = fromStateResId;
  }

  public ResourceIdentifier getToStateResId() {
    return toStateResId;
  }

  public void setToStateResId(ResourceIdentifier toStateResId) {
    this.toStateResId = toStateResId;
  }

  public OffsetDateTime getActualTransitionDate() {
    return actualTransitionDate;
  }

  public void setActualTransitionDate(OffsetDateTime actualTransitionDate) {
    this.actualTransitionDate = actualTransitionDate;
  }

  @Override
  public String toString() {
    return "TransitionStagedOrderLineItemStateOutput{type='" + type + "', lineItemId='" + lineItemId + "', lineItemKey='" + lineItemKey + "', quantity='" + quantity + "', fromStateResId='" + fromStateResId + "', toStateResId='" + toStateResId + "', actualTransitionDate='" + actualTransitionDate + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    TransitionStagedOrderLineItemStateOutput that = (TransitionStagedOrderLineItemStateOutput) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(lineItemId, that.lineItemId) &&
        Objects.equals(lineItemKey, that.lineItemKey) &&
        Objects.equals(quantity, that.quantity) &&
        Objects.equals(fromStateResId, that.fromStateResId) &&
        Objects.equals(toStateResId, that.toStateResId) &&
        Objects.equals(actualTransitionDate, that.actualTransitionDate);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, lineItemId, lineItemKey, quantity, fromStateResId, toStateResId, actualTransitionDate);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    private String lineItemId;

    private String lineItemKey;

    private Long quantity;

    private ResourceIdentifier fromStateResId;

    private ResourceIdentifier toStateResId;

    private OffsetDateTime actualTransitionDate;

    public TransitionStagedOrderLineItemStateOutput build() {
      TransitionStagedOrderLineItemStateOutput result = new TransitionStagedOrderLineItemStateOutput();
      result.type = this.type;
      result.lineItemId = this.lineItemId;
      result.lineItemKey = this.lineItemKey;
      result.quantity = this.quantity;
      result.fromStateResId = this.fromStateResId;
      result.toStateResId = this.toStateResId;
      result.actualTransitionDate = this.actualTransitionDate;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder lineItemId(String lineItemId) {
      this.lineItemId = lineItemId;
      return this;
    }

    public Builder lineItemKey(String lineItemKey) {
      this.lineItemKey = lineItemKey;
      return this;
    }

    public Builder quantity(Long quantity) {
      this.quantity = quantity;
      return this;
    }

    public Builder fromStateResId(ResourceIdentifier fromStateResId) {
      this.fromStateResId = fromStateResId;
      return this;
    }

    public Builder toStateResId(ResourceIdentifier toStateResId) {
      this.toStateResId = toStateResId;
      return this;
    }

    public Builder actualTransitionDate(OffsetDateTime actualTransitionDate) {
      this.actualTransitionDate = actualTransitionDate;
      return this;
    }
  }
}
