package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class TransitionStagedOrderStateOutput implements com.commercetools.graphql.api.types.StagedOrderUpdateActionOutput {
  private String type;

  private ResourceIdentifier stateResId;

  private Boolean force;

  public TransitionStagedOrderStateOutput() {
  }

  public TransitionStagedOrderStateOutput(String type, ResourceIdentifier stateResId,
      Boolean force) {
    this.type = type;
    this.stateResId = stateResId;
    this.force = force;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public ResourceIdentifier getStateResId() {
    return stateResId;
  }

  public void setStateResId(ResourceIdentifier stateResId) {
    this.stateResId = stateResId;
  }

  public Boolean getForce() {
    return force;
  }

  public void setForce(Boolean force) {
    this.force = force;
  }

  @Override
  public String toString() {
    return "TransitionStagedOrderStateOutput{type='" + type + "', stateResId='" + stateResId + "', force='" + force + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    TransitionStagedOrderStateOutput that = (TransitionStagedOrderStateOutput) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(stateResId, that.stateResId) &&
        Objects.equals(force, that.force);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, stateResId, force);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    private ResourceIdentifier stateResId;

    private Boolean force;

    public TransitionStagedOrderStateOutput build() {
      TransitionStagedOrderStateOutput result = new TransitionStagedOrderStateOutput();
      result.type = this.type;
      result.stateResId = this.stateResId;
      result.force = this.force;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder stateResId(ResourceIdentifier stateResId) {
      this.stateResId = stateResId;
      return this;
    }

    public Builder force(Boolean force) {
      this.force = force;
      return this;
    }
  }
}
