package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class TreeFilterInput {
  private String path;

  private List<String> rootValues;

  private List<String> subTreeValues;

  public TreeFilterInput() {
  }

  public TreeFilterInput(String path, List<String> rootValues, List<String> subTreeValues) {
    this.path = path;
    this.rootValues = rootValues;
    this.subTreeValues = subTreeValues;
  }

  public String getPath() {
    return path;
  }

  public void setPath(String path) {
    this.path = path;
  }

  public List<String> getRootValues() {
    return rootValues;
  }

  public void setRootValues(List<String> rootValues) {
    this.rootValues = rootValues;
  }

  public List<String> getSubTreeValues() {
    return subTreeValues;
  }

  public void setSubTreeValues(List<String> subTreeValues) {
    this.subTreeValues = subTreeValues;
  }

  @Override
  public String toString() {
    return "TreeFilterInput{path='" + path + "', rootValues='" + rootValues + "', subTreeValues='" + subTreeValues + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    TreeFilterInput that = (TreeFilterInput) o;
    return Objects.equals(path, that.path) &&
        Objects.equals(rootValues, that.rootValues) &&
        Objects.equals(subTreeValues, that.subTreeValues);
  }

  @Override
  public int hashCode() {
    return Objects.hash(path, rootValues, subTreeValues);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String path;

    private List<String> rootValues;

    private List<String> subTreeValues;

    public TreeFilterInput build() {
      TreeFilterInput result = new TreeFilterInput();
      result.path = this.path;
      result.rootValues = this.rootValues;
      result.subTreeValues = this.subTreeValues;
      return result;
    }

    public Builder path(String path) {
      this.path = path;
      return this;
    }

    public Builder rootValues(List<String> rootValues) {
      this.rootValues = rootValues;
      return this;
    }

    public Builder subTreeValues(List<String> subTreeValues) {
      this.subTreeValues = subTreeValues;
      return this;
    }
  }
}
