package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class TriggerInput {
  private String resourceTypeId;

  private List<ActionType> actions;

  private String condition;

  public TriggerInput() {
  }

  public TriggerInput(String resourceTypeId, List<ActionType> actions, String condition) {
    this.resourceTypeId = resourceTypeId;
    this.actions = actions;
    this.condition = condition;
  }

  public String getResourceTypeId() {
    return resourceTypeId;
  }

  public void setResourceTypeId(String resourceTypeId) {
    this.resourceTypeId = resourceTypeId;
  }

  public List<ActionType> getActions() {
    return actions;
  }

  public void setActions(List<ActionType> actions) {
    this.actions = actions;
  }

  public String getCondition() {
    return condition;
  }

  public void setCondition(String condition) {
    this.condition = condition;
  }

  @Override
  public String toString() {
    return "TriggerInput{resourceTypeId='" + resourceTypeId + "', actions='" + actions + "', condition='" + condition + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    TriggerInput that = (TriggerInput) o;
    return Objects.equals(resourceTypeId, that.resourceTypeId) &&
        Objects.equals(actions, that.actions) &&
        Objects.equals(condition, that.condition);
  }

  @Override
  public int hashCode() {
    return Objects.hash(resourceTypeId, actions, condition);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String resourceTypeId;

    private List<ActionType> actions;

    private String condition;

    public TriggerInput build() {
      TriggerInput result = new TriggerInput();
      result.resourceTypeId = this.resourceTypeId;
      result.actions = this.actions;
      result.condition = this.condition;
      return result;
    }

    public Builder resourceTypeId(String resourceTypeId) {
      this.resourceTypeId = resourceTypeId;
      return this;
    }

    public Builder actions(List<ActionType> actions) {
      this.actions = actions;
      return this;
    }

    public Builder condition(String condition) {
      this.condition = condition;
      return this;
    }
  }
}
