package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class TypeDefinitionDraft {
  private String key;

  private List<LocalizedStringItemInputType> name;

  private List<LocalizedStringItemInputType> description;

  private List<String> resourceTypeIds;

  private List<FieldDefinitionInput> fieldDefinitions;

  public TypeDefinitionDraft() {
  }

  public TypeDefinitionDraft(String key, List<LocalizedStringItemInputType> name,
      List<LocalizedStringItemInputType> description, List<String> resourceTypeIds,
      List<FieldDefinitionInput> fieldDefinitions) {
    this.key = key;
    this.name = name;
    this.description = description;
    this.resourceTypeIds = resourceTypeIds;
    this.fieldDefinitions = fieldDefinitions;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public List<LocalizedStringItemInputType> getName() {
    return name;
  }

  public void setName(List<LocalizedStringItemInputType> name) {
    this.name = name;
  }

  public List<LocalizedStringItemInputType> getDescription() {
    return description;
  }

  public void setDescription(List<LocalizedStringItemInputType> description) {
    this.description = description;
  }

  public List<String> getResourceTypeIds() {
    return resourceTypeIds;
  }

  public void setResourceTypeIds(List<String> resourceTypeIds) {
    this.resourceTypeIds = resourceTypeIds;
  }

  public List<FieldDefinitionInput> getFieldDefinitions() {
    return fieldDefinitions;
  }

  public void setFieldDefinitions(List<FieldDefinitionInput> fieldDefinitions) {
    this.fieldDefinitions = fieldDefinitions;
  }

  @Override
  public String toString() {
    return "TypeDefinitionDraft{key='" + key + "', name='" + name + "', description='" + description + "', resourceTypeIds='" + resourceTypeIds + "', fieldDefinitions='" + fieldDefinitions + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    TypeDefinitionDraft that = (TypeDefinitionDraft) o;
    return Objects.equals(key, that.key) &&
        Objects.equals(name, that.name) &&
        Objects.equals(description, that.description) &&
        Objects.equals(resourceTypeIds, that.resourceTypeIds) &&
        Objects.equals(fieldDefinitions, that.fieldDefinitions);
  }

  @Override
  public int hashCode() {
    return Objects.hash(key, name, description, resourceTypeIds, fieldDefinitions);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String key;

    private List<LocalizedStringItemInputType> name;

    private List<LocalizedStringItemInputType> description;

    private List<String> resourceTypeIds;

    private List<FieldDefinitionInput> fieldDefinitions;

    public TypeDefinitionDraft build() {
      TypeDefinitionDraft result = new TypeDefinitionDraft();
      result.key = this.key;
      result.name = this.name;
      result.description = this.description;
      result.resourceTypeIds = this.resourceTypeIds;
      result.fieldDefinitions = this.fieldDefinitions;
      return result;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder name(List<LocalizedStringItemInputType> name) {
      this.name = name;
      return this;
    }

    public Builder description(List<LocalizedStringItemInputType> description) {
      this.description = description;
      return this;
    }

    public Builder resourceTypeIds(List<String> resourceTypeIds) {
      this.resourceTypeIds = resourceTypeIds;
      return this;
    }

    public Builder fieldDefinitions(List<FieldDefinitionInput> fieldDefinitions) {
      this.fieldDefinitions = fieldDefinitions;
      return this;
    }
  }
}
