package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class UpdateStagedOrderSyncInfoOutput implements com.commercetools.graphql.api.types.StagedOrderUpdateActionOutput {
  private String type;

  private ChannelReferenceIdentifier channelResId;

  private OffsetDateTime syncedAt;

  private String externalId;

  public UpdateStagedOrderSyncInfoOutput() {
  }

  public UpdateStagedOrderSyncInfoOutput(String type, ChannelReferenceIdentifier channelResId,
      OffsetDateTime syncedAt, String externalId) {
    this.type = type;
    this.channelResId = channelResId;
    this.syncedAt = syncedAt;
    this.externalId = externalId;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public ChannelReferenceIdentifier getChannelResId() {
    return channelResId;
  }

  public void setChannelResId(ChannelReferenceIdentifier channelResId) {
    this.channelResId = channelResId;
  }

  public OffsetDateTime getSyncedAt() {
    return syncedAt;
  }

  public void setSyncedAt(OffsetDateTime syncedAt) {
    this.syncedAt = syncedAt;
  }

  public String getExternalId() {
    return externalId;
  }

  public void setExternalId(String externalId) {
    this.externalId = externalId;
  }

  @Override
  public String toString() {
    return "UpdateStagedOrderSyncInfoOutput{type='" + type + "', channelResId='" + channelResId + "', syncedAt='" + syncedAt + "', externalId='" + externalId + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    UpdateStagedOrderSyncInfoOutput that = (UpdateStagedOrderSyncInfoOutput) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(channelResId, that.channelResId) &&
        Objects.equals(syncedAt, that.syncedAt) &&
        Objects.equals(externalId, that.externalId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, channelResId, syncedAt, externalId);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    private ChannelReferenceIdentifier channelResId;

    private OffsetDateTime syncedAt;

    private String externalId;

    public UpdateStagedOrderSyncInfoOutput build() {
      UpdateStagedOrderSyncInfoOutput result = new UpdateStagedOrderSyncInfoOutput();
      result.type = this.type;
      result.channelResId = this.channelResId;
      result.syncedAt = this.syncedAt;
      result.externalId = this.externalId;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder channelResId(ChannelReferenceIdentifier channelResId) {
      this.channelResId = channelResId;
      return this;
    }

    public Builder syncedAt(OffsetDateTime syncedAt) {
      this.syncedAt = syncedAt;
      return this;
    }

    public Builder externalId(String externalId) {
      this.externalId = externalId;
      return this;
    }
  }
}
