package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class ValueFacetResult implements com.commercetools.graphql.api.types.FacetResult {
  private Integer count;

  private Integer productCount;

  private String type;

  public ValueFacetResult() {
  }

  public ValueFacetResult(Integer count, Integer productCount, String type) {
    this.count = count;
    this.productCount = productCount;
    this.type = type;
  }

  public Integer getCount() {
    return count;
  }

  public void setCount(Integer count) {
    this.count = count;
  }

  public Integer getProductCount() {
    return productCount;
  }

  public void setProductCount(Integer productCount) {
    this.productCount = productCount;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "ValueFacetResult{count='" + count + "', productCount='" + productCount + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ValueFacetResult that = (ValueFacetResult) o;
    return Objects.equals(count, that.count) &&
        Objects.equals(productCount, that.productCount) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(count, productCount, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Integer count;

    private Integer productCount;

    private String type;

    public ValueFacetResult build() {
      ValueFacetResult result = new ValueFacetResult();
      result.count = this.count;
      result.productCount = this.productCount;
      result.type = this.type;
      return result;
    }

    public Builder count(Integer count) {
      this.count = count;
      return this;
    }

    public Builder productCount(Integer productCount) {
      this.productCount = productCount;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
