package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class changeEnumKey {
  private String attributeName;

  private String key;

  private String newKey;

  public changeEnumKey() {
  }

  public changeEnumKey(String attributeName, String key, String newKey) {
    this.attributeName = attributeName;
    this.key = key;
    this.newKey = newKey;
  }

  public String getAttributeName() {
    return attributeName;
  }

  public void setAttributeName(String attributeName) {
    this.attributeName = attributeName;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public String getNewKey() {
    return newKey;
  }

  public void setNewKey(String newKey) {
    this.newKey = newKey;
  }

  @Override
  public String toString() {
    return "changeEnumKey{attributeName='" + attributeName + "', key='" + key + "', newKey='" + newKey + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    changeEnumKey that = (changeEnumKey) o;
    return Objects.equals(attributeName, that.attributeName) &&
        Objects.equals(key, that.key) &&
        Objects.equals(newKey, that.newKey);
  }

  @Override
  public int hashCode() {
    return Objects.hash(attributeName, key, newKey);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String attributeName;

    private String key;

    private String newKey;

    public changeEnumKey build() {
      changeEnumKey result = new changeEnumKey();
      result.attributeName = this.attributeName;
      result.key = this.key;
      result.newKey = this.newKey;
      return result;
    }

    public Builder attributeName(String attributeName) {
      this.attributeName = attributeName;
      return this;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder newKey(String newKey) {
      this.newKey = newKey;
      return this;
    }
  }
}
