package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class changeLocalizedEnumValueLabel {
  private String attributeName;

  private LocalizedEnumValueDraft newValue;

  public changeLocalizedEnumValueLabel() {
  }

  public changeLocalizedEnumValueLabel(String attributeName, LocalizedEnumValueDraft newValue) {
    this.attributeName = attributeName;
    this.newValue = newValue;
  }

  public String getAttributeName() {
    return attributeName;
  }

  public void setAttributeName(String attributeName) {
    this.attributeName = attributeName;
  }

  public LocalizedEnumValueDraft getNewValue() {
    return newValue;
  }

  public void setNewValue(LocalizedEnumValueDraft newValue) {
    this.newValue = newValue;
  }

  @Override
  public String toString() {
    return "changeLocalizedEnumValueLabel{attributeName='" + attributeName + "', newValue='" + newValue + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    changeLocalizedEnumValueLabel that = (changeLocalizedEnumValueLabel) o;
    return Objects.equals(attributeName, that.attributeName) &&
        Objects.equals(newValue, that.newValue);
  }

  @Override
  public int hashCode() {
    return Objects.hash(attributeName, newValue);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String attributeName;

    private LocalizedEnumValueDraft newValue;

    public changeLocalizedEnumValueLabel build() {
      changeLocalizedEnumValueLabel result = new changeLocalizedEnumValueLabel();
      result.attributeName = this.attributeName;
      result.newValue = this.newValue;
      return result;
    }

    public Builder attributeName(String attributeName) {
      this.attributeName = attributeName;
      return this;
    }

    public Builder newValue(LocalizedEnumValueDraft newValue) {
      this.newValue = newValue;
      return this;
    }
  }
}
