package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class changePlainEnumValueOrder {
  private String attributeName;

  private List<PlainEnumValueDraft> values;

  public changePlainEnumValueOrder() {
  }

  public changePlainEnumValueOrder(String attributeName, List<PlainEnumValueDraft> values) {
    this.attributeName = attributeName;
    this.values = values;
  }

  public String getAttributeName() {
    return attributeName;
  }

  public void setAttributeName(String attributeName) {
    this.attributeName = attributeName;
  }

  public List<PlainEnumValueDraft> getValues() {
    return values;
  }

  public void setValues(List<PlainEnumValueDraft> values) {
    this.values = values;
  }

  @Override
  public String toString() {
    return "changePlainEnumValueOrder{attributeName='" + attributeName + "', values='" + values + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    changePlainEnumValueOrder that = (changePlainEnumValueOrder) o;
    return Objects.equals(attributeName, that.attributeName) &&
        Objects.equals(values, that.values);
  }

  @Override
  public int hashCode() {
    return Objects.hash(attributeName, values);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String attributeName;

    private List<PlainEnumValueDraft> values;

    public changePlainEnumValueOrder build() {
      changePlainEnumValueOrder result = new changePlainEnumValueOrder();
      result.attributeName = this.attributeName;
      result.values = this.values;
      return result;
    }

    public Builder attributeName(String attributeName) {
      this.attributeName = attributeName;
      return this;
    }

    public Builder values(List<PlainEnumValueDraft> values) {
      this.values = values;
      return this;
    }
  }
}
