/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.http.javanet;

import com.commercetools.http.javanet.BuilderOptions;
import com.commercetools.http.javanet.HttpException;
import io.vrap.rmf.base.client.ApiHttpHeaders;
import io.vrap.rmf.base.client.ApiHttpRequest;
import io.vrap.rmf.base.client.ApiHttpResponse;
import io.vrap.rmf.base.client.HttpClientBase;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.AutoCloseInputStream;

public class CtJavaNetHttpClient
extends HttpClientBase {
    private final HttpClient javaHttpClient;
    private static final String APPLICATION_JSON = "application/json";
    private final Supplier<HttpClient.Builder> clientBuilder = HttpClient::newBuilder;

    public CtJavaNetHttpClient() {
        this.javaHttpClient = this.clientBuilder.get().build();
    }

    public CtJavaNetHttpClient(BuilderOptions options) {
        this.javaHttpClient = options.plus(this.clientBuilder.get()).build();
    }

    public CtJavaNetHttpClient(Supplier<HttpClient.Builder> builderSupplier) {
        this.javaHttpClient = builderSupplier.get().build();
    }

    public CtJavaNetHttpClient(ExecutorService executor) {
        super(executor);
        this.javaHttpClient = this.clientBuilder.get().build();
    }

    public CtJavaNetHttpClient(ExecutorService executor, BuilderOptions options) {
        super(executor);
        this.javaHttpClient = options.plus(this.clientBuilder.get()).build();
    }

    public CtJavaNetHttpClient(ExecutorService executor, Supplier<HttpClient.Builder> builderSupplier) {
        super(executor);
        this.javaHttpClient = builderSupplier.get().build();
    }

    private HttpRequest toJavaNetRequest(ApiHttpRequest httpRequest) {
        HttpRequest.Builder builder = HttpRequest.newBuilder();
        String method = httpRequest.getMethod().toString();
        builder.uri(httpRequest.getUri());
        httpRequest.getHeaders().getHeaders().forEach(entry -> builder.header((String)entry.getKey(), (String)entry.getValue()));
        if (httpRequest.getBody() != null) {
            String mediaType = APPLICATION_JSON;
            if (httpRequest.getHeaders().getHeaders().stream().anyMatch(s -> ((String)s.getKey()).equalsIgnoreCase("Content-Type"))) {
                mediaType = httpRequest.getHeaders().getFirst("Content-Type");
            }
            builder.setHeader("Content-Type", mediaType);
            builder.method(method, HttpRequest.BodyPublishers.ofByteArray(httpRequest.getBody()));
        } else {
            builder.method(method, HttpRequest.BodyPublishers.noBody());
        }
        return builder.build();
    }

    public CompletableFuture<ApiHttpResponse<byte[]>> execute(ApiHttpRequest request) {
        return this.javaHttpClient.sendAsync(this.toJavaNetRequest(request), HttpResponse.BodyHandlers.ofByteArray()).thenApplyAsync(CtJavaNetHttpClient::toResponse, this.executor());
    }

    private static ApiHttpResponse<byte[]> toResponse(HttpResponse<byte[]> response) {
        ApiHttpHeaders apiHttpHeaders = new ApiHttpHeaders(response.headers().map().entrySet().stream().flatMap(e -> ((List)e.getValue()).stream().map(value -> ApiHttpHeaders.headerEntry((String)((String)e.getKey()), (String)value))).collect(Collectors.toList()));
        byte[] bodyNullable = Optional.ofNullable(response.body()).map(entity -> {
            try {
                boolean gzipEncoded = response.headers().firstValue("Content-Encoding").map(v -> v.equalsIgnoreCase("gzip")).orElse(false);
                ByteArrayInputStream body = new ByteArrayInputStream((byte[])entity);
                InputStream content = gzipEncoded ? new GZIPInputStream(body) : body;
                AutoCloseInputStream autoCloseInputStream = new AutoCloseInputStream(content);
                return IOUtils.toByteArray((InputStream)autoCloseInputStream);
            }
            catch (IOException e) {
                throw new HttpException(e);
            }
        }).orElse(null);
        return new ApiHttpResponse(response.statusCode(), apiHttpHeaders, (Object)bodyNullable);
    }

    public void closeDelegate() throws Exception {
    }
}

