/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.monitoring.datadog;

import com.commercetools.monitoring.datadog.DatadogUtils;
import com.datadog.api.client.ApiClient;
import com.datadog.api.client.v2.api.MetricsApi;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import io.vrap.rmf.base.client.ApiHttpResponse;
import io.vrap.rmf.base.client.ResponseSerializer;
import java.time.Duration;
import java.time.Instant;

public class DatadogResponseSerializer
implements ResponseSerializer {
    private final ResponseSerializer serializer;
    private final MetricsApi apiInstance;

    public DatadogResponseSerializer(ResponseSerializer serializer, MetricsApi apiInstance) {
        this.serializer = serializer;
        this.apiInstance = apiInstance;
    }

    public DatadogResponseSerializer(ResponseSerializer serializer, ApiClient ddApiClient) {
        this.serializer = serializer;
        this.apiInstance = new MetricsApi(ddApiClient);
    }

    public <O> ApiHttpResponse<O> convertResponse(ApiHttpResponse<byte[]> response, Class<O> outputType) {
        Instant start = Instant.now();
        ApiHttpResponse result = this.serializer.convertResponse(response, outputType);
        double durationInMillis = (double)Duration.between(start, Instant.now()).toNanos() / 1000000.0;
        DatadogUtils.submitJsonDeserializationMetric(this.apiInstance, durationInMillis, outputType.getCanonicalName());
        return result;
    }

    public <O> ApiHttpResponse<O> convertResponse(ApiHttpResponse<byte[]> response, JavaType outputType) {
        Instant start = Instant.now();
        ApiHttpResponse result = this.serializer.convertResponse(response, outputType);
        double durationInMillis = (double)Duration.between(start, Instant.now()).toNanos() / 1000000.0;
        DatadogUtils.submitJsonDeserializationMetric(this.apiInstance, durationInMillis, outputType.toString());
        return result;
    }

    public <O> ApiHttpResponse<O> convertResponse(ApiHttpResponse<byte[]> response, TypeReference<O> outputType) {
        Instant start = Instant.now();
        ApiHttpResponse result = this.serializer.convertResponse(response, outputType);
        double durationInMillis = (double)Duration.between(start, Instant.now()).toNanos() / 1000000.0;
        DatadogUtils.submitJsonDeserializationMetric(this.apiInstance, durationInMillis, outputType.getType().getTypeName());
        return result;
    }

    public byte[] toJsonByteArray(Object value) throws JsonProcessingException {
        Instant start = Instant.now();
        byte[] result = this.serializer.toJsonByteArray(value);
        double durationInMillis = (double)Duration.between(start, Instant.now()).toNanos() / 1000000.0;
        DatadogUtils.submitJsonSerializationMetric(this.apiInstance, durationInMillis, value.getClass().getCanonicalName());
        return result;
    }
}

