/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.monitoring.datadog.statsd;

import com.timgroup.statsd.StatsDClient;
import io.vrap.rmf.base.client.ApiHttpRequest;
import io.vrap.rmf.base.client.ApiHttpResponse;
import io.vrap.rmf.base.client.http.TelemetryMiddleware;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public class DatadogMiddleware
implements TelemetryMiddleware {
    private final StatsDClient statsDClient;

    public DatadogMiddleware(StatsDClient datadogStatsDClient) {
        this.statsDClient = datadogStatsDClient;
    }

    public CompletableFuture<ApiHttpResponse<byte[]>> invoke(ApiHttpRequest request, Function<ApiHttpRequest, CompletableFuture<ApiHttpResponse<byte[]>>> next) {
        Instant start = Instant.now();
        return next.apply(request).thenApply(response -> {
            ArrayList<String> tags = new ArrayList<String>(4);
            tags.add(String.format("%s:%s", "http.response.status_code", response.getStatusCode()));
            tags.add(String.format("%s:%s", "http.request.method", request.getMethod().name()));
            tags.add(String.format("%s:%s", "server.address", request.getUri().getHost()));
            if (request.getUri().getPort() > 0) {
                tags.add(String.format("%s:%s", "server.port", request.getUri().getPort()));
            }
            this.statsDClient.recordHistogramValue("commercetools.client.duration", Duration.between(start, Instant.now()).toMillis(), tags.toArray(new String[0]));
            this.statsDClient.incrementCounter("commercetools.client.request.total", tags.toArray(new String[0]));
            if (response.getStatusCode() >= 400) {
                this.statsDClient.incrementCounter("commercetools.client.request.error", tags.toArray(new String[0]));
            }
            return response;
        });
    }
}

