/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.monitoring.datadog.statsd;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.timgroup.statsd.StatsDClient;
import io.vrap.rmf.base.client.ApiHttpResponse;
import io.vrap.rmf.base.client.ResponseSerializer;
import java.time.Duration;
import java.time.Instant;

public class DatadogResponseSerializer
implements ResponseSerializer {
    private final ResponseSerializer serializer;
    private final StatsDClient statsDClient;

    public DatadogResponseSerializer(ResponseSerializer serializer, StatsDClient datadogStatsDClient) {
        this.serializer = serializer;
        this.statsDClient = datadogStatsDClient;
    }

    public <O> ApiHttpResponse<O> convertResponse(ApiHttpResponse<byte[]> response, Class<O> outputType) {
        Instant start = Instant.now();
        ApiHttpResponse result = this.serializer.convertResponse(response, outputType);
        long durationInMillis = Duration.between(start, Instant.now()).toMillis();
        this.statsDClient.recordHistogramValue("commercetools.json.deserialization", durationInMillis, new String[]{String.format("%s:%s", "response.body.type", outputType.getCanonicalName())});
        return result;
    }

    public <O> ApiHttpResponse<O> convertResponse(ApiHttpResponse<byte[]> response, JavaType outputType) {
        Instant start = Instant.now();
        ApiHttpResponse result = this.serializer.convertResponse(response, outputType);
        long durationInMillis = Duration.between(start, Instant.now()).toMillis();
        this.statsDClient.recordHistogramValue("commercetools.json.deserialization", durationInMillis, new String[]{String.format("%s:%s", "response.body.type", outputType.toString())});
        return result;
    }

    public <O> ApiHttpResponse<O> convertResponse(ApiHttpResponse<byte[]> response, TypeReference<O> outputType) {
        Instant start = Instant.now();
        ApiHttpResponse result = this.serializer.convertResponse(response, outputType);
        long durationInMillis = Duration.between(start, Instant.now()).toMillis();
        this.statsDClient.recordHistogramValue("commercetools.json.deserialization", durationInMillis, new String[]{String.format("%s:%s", "response.body.type", outputType.getType().getTypeName())});
        return result;
    }

    public byte[] toJsonByteArray(Object value) throws JsonProcessingException {
        Instant start = Instant.now();
        byte[] result = this.serializer.toJsonByteArray(value);
        long durationInMillis = Duration.between(start, Instant.now()).toMillis();
        this.statsDClient.recordHistogramValue("commercetools.json.serialization", durationInMillis, new String[]{String.format("%s:%s", "request.body.type", value.getClass().getCanonicalName())});
        return result;
    }
}

