/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.monitoring.datadog;

import com.commercetools.monitoring.datadog.DatadogUtils;
import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.v2.api.MetricsApi;
import io.vrap.rmf.base.client.ApiHttpRequest;
import io.vrap.rmf.base.client.ApiHttpResponse;
import io.vrap.rmf.base.client.http.TelemetryMiddleware;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public class DatadogMiddleware
implements TelemetryMiddleware {
    private final MetricsApi apiInstance;

    public DatadogMiddleware(ApiClient ddApiClient) {
        this.apiInstance = new MetricsApi(ddApiClient);
    }

    public DatadogMiddleware(MetricsApi apiInstance) {
        this.apiInstance = apiInstance;
    }

    public CompletableFuture<ApiHttpResponse<byte[]>> invoke(ApiHttpRequest request, Function<ApiHttpRequest, CompletableFuture<ApiHttpResponse<byte[]>>> next) {
        Instant start = Instant.now();
        return next.apply(request).thenApply(response -> {
            try {
                DatadogUtils.submitClientDurationMetric(request, this.apiInstance, Duration.between(start, Instant.now()).toMillis(), (ApiHttpResponse<byte[]>)response);
                DatadogUtils.submitTotalRequestsMetric(request, this.apiInstance, (ApiHttpResponse<byte[]>)response);
                if (response.getStatusCode() >= 400) {
                    DatadogUtils.submitErrorRequestsMetric(request, this.apiInstance, (ApiHttpResponse<byte[]>)response);
                }
            }
            catch (ApiException e) {
                throw new RuntimeException(e);
            }
            return response;
        });
    }
}

