/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.monitoring.datadog;

import com.commercetools.monitoring.datadog.DatadogMiddleware;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.v2.api.MetricsApi;
import com.datadog.api.client.v2.model.MetricIntakeType;
import com.datadog.api.client.v2.model.MetricPayload;
import com.datadog.api.client.v2.model.MetricPoint;
import com.datadog.api.client.v2.model.MetricSeries;
import io.vrap.rmf.base.client.ApiHttpRequest;
import io.vrap.rmf.base.client.ApiHttpResponse;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatadogUtils {
    private static final Logger logger = LoggerFactory.getLogger(DatadogMiddleware.class);

    protected static void submitClientDurationMetric(ApiHttpRequest request, MetricsApi apiInstance, double durationInMillis, ApiHttpResponse<byte[]> response) throws ApiException {
        String name = "commercetools.client.duration";
        MetricIntakeType type = MetricIntakeType.UNSPECIFIED;
        DatadogUtils.submitMetricWithHttpTags("commercetools.client.duration", durationInMillis, type, "ms", request, apiInstance, response);
    }

    protected static void submitErrorRequestsMetric(ApiHttpRequest request, MetricsApi apiInstance, ApiHttpResponse<byte[]> response) throws ApiException {
        String name = "commercetools.client.request.error";
        MetricIntakeType count = MetricIntakeType.COUNT;
        DatadogUtils.submitMetricWithHttpTags("commercetools.client.request.error", 1.0, count, "count", request, apiInstance, response);
    }

    protected static void submitTotalRequestsMetric(ApiHttpRequest request, MetricsApi apiInstance, ApiHttpResponse<byte[]> response) throws ApiException {
        String name = "commercetools.client.request.total";
        MetricIntakeType count = MetricIntakeType.COUNT;
        DatadogUtils.submitMetricWithHttpTags("commercetools.client.request.total", 1.0, count, "count", request, apiInstance, response);
    }

    private static void submitMetricWithHttpTags(String name, double value, MetricIntakeType type, String unit, ApiHttpRequest request, MetricsApi apiInstance, ApiHttpResponse<byte[]> response) throws ApiException {
        List<String> tags = Arrays.asList(String.format("%s:%s", "http.response.status_code", response.getStatusCode()), String.format("%s:%s", "http.request.method", request.getMethod().name()), String.format("%s:%s", "server.address", request.getUri().getHost()));
        if (request.getUri().getPort() > 0) {
            tags.add(String.format("%s:%s", "server.port", request.getUri().getPort()));
        }
        DatadogUtils.submitMetric(apiInstance, name, value, type, unit, tags);
    }

    protected static void submitJsonSerializationMetric(MetricsApi apiInstance, double durationInMillis, String responseBodyType) {
        try {
            DatadogUtils.submitMetric(apiInstance, "commercetools.json.serialization", durationInMillis, MetricIntakeType.UNSPECIFIED, "ms", Arrays.asList(String.format("%s:%s", "response.body.type", responseBodyType)));
        }
        catch (ApiException exception) {
            logger.warn("Failed to submit commercetools json serialization metric", (Throwable)exception);
        }
    }

    protected static void submitJsonDeserializationMetric(MetricsApi apiInstance, double durationInMillis, String requestBodyType) {
        try {
            DatadogUtils.submitMetric(apiInstance, "commercetools.json.deserialization", durationInMillis, MetricIntakeType.UNSPECIFIED, "ms", Arrays.asList(String.format("%s:%s", "request.body.type", requestBodyType)));
        }
        catch (ApiException exception) {
            logger.warn("Failed to submit commercetools json deserialization metric", (Throwable)exception);
        }
    }

    private static void submitMetric(MetricsApi apiInstance, String name, double value, MetricIntakeType type, String unit, List<String> tags) throws ApiException {
        MetricPayload totalMetric = new MetricPayload().series(Collections.singletonList(new MetricSeries().metric(name).type(type).unit(unit).points(Collections.singletonList(new MetricPoint().timestamp(Long.valueOf(OffsetDateTime.now().toInstant().getEpochSecond())).value(Double.valueOf(value)))).tags(tags)));
        apiInstance.submitMetrics(totalMetric);
    }
}

