/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.monitoring.newrelic;

import com.commercetools.monitoring.newrelic.NewRelicContext;
import com.newrelic.api.agent.ExternalParameters;
import com.newrelic.api.agent.HttpParameters;
import com.newrelic.api.agent.Segment;
import com.newrelic.api.agent.Token;
import com.newrelic.api.agent.Trace;
import com.newrelic.api.agent.Transaction;
import io.vrap.rmf.base.client.ApiHttpRequest;
import io.vrap.rmf.base.client.ApiHttpResponse;
import io.vrap.rmf.base.client.http.TelemetryMiddleware;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public class NewRelicTelemetryMiddleware
implements TelemetryMiddleware {
    @Trace(async=true)
    public CompletableFuture<ApiHttpResponse<byte[]>> invoke(ApiHttpRequest request, Function<ApiHttpRequest, CompletableFuture<ApiHttpResponse<byte[]>>> next) {
        Optional<Object> context = Optional.ofNullable(request.getContext(NewRelicContext.class));
        context.map(NewRelicContext::getToken).ifPresent(Token::link);
        Optional<Token> token = context.map(NewRelicContext::getTransaction).map(Transaction::getToken);
        Optional<Segment> segment = context.map(c -> c.getTransaction().startSegment("commercetools", request.getMethod() + " " + request.getUri().getPath()));
        return next.apply(request).thenApply(response -> {
            token.ifPresent(Token::linkAndExpire);
            segment.ifPresent(s -> s.reportAsExternal((ExternalParameters)HttpParameters.library((String)"commercetools-sdk-java-v2").uri(request.getUri()).procedure(request.getMethod().name()).noInboundHeaders().status(Integer.valueOf(response.getStatusCode()), response.getMessage()).build()));
            segment.ifPresent(Segment::end);
            return response;
        });
    }
}

