/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.monitoring.newrelic;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.newrelic.api.agent.NewRelic;
import io.vrap.rmf.base.client.ApiHttpResponse;
import io.vrap.rmf.base.client.ResponseSerializer;
import java.time.Duration;
import java.time.Instant;

public class NewrelicResponseSerializer
implements ResponseSerializer {
    private final ResponseSerializer serializer;

    public NewrelicResponseSerializer(ResponseSerializer serializer) {
        this.serializer = serializer;
    }

    public <O> ApiHttpResponse<O> convertResponse(ApiHttpResponse<byte[]> response, Class<O> outputType) {
        Instant start = Instant.now();
        ApiHttpResponse result = this.serializer.convertResponse(response, outputType);
        long durationInMillis = Duration.between(start, Instant.now()).toMillis();
        NewRelic.recordResponseTimeMetric((String)"Custom/Commercetools/Json/Serialization", (long)durationInMillis);
        return result;
    }

    public <O> ApiHttpResponse<O> convertResponse(ApiHttpResponse<byte[]> response, JavaType outputType) {
        Instant start = Instant.now();
        ApiHttpResponse result = this.serializer.convertResponse(response, outputType);
        long durationInMillis = Duration.between(start, Instant.now()).toMillis();
        NewRelic.recordResponseTimeMetric((String)"Custom/Commercetools/Json/Serialization", (long)durationInMillis);
        return result;
    }

    public <O> ApiHttpResponse<O> convertResponse(ApiHttpResponse<byte[]> response, TypeReference<O> outputType) {
        Instant start = Instant.now();
        ApiHttpResponse result = this.serializer.convertResponse(response, outputType);
        long durationInMillis = Duration.between(start, Instant.now()).toMillis();
        NewRelic.recordResponseTimeMetric((String)"Custom/Commercetools/Json/Serialization", (long)durationInMillis);
        return result;
    }

    public byte[] toJsonByteArray(Object value) throws JsonProcessingException {
        Instant start = Instant.now();
        byte[] result = this.serializer.toJsonByteArray(value);
        long durationInMillis = Duration.between(start, Instant.now()).toMillis();
        NewRelic.recordResponseTimeMetric((String)"Custom/Commercetools/Json/Deserialization", (long)durationInMillis);
        return result;
    }
}

