/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.http.okhttp4;

import com.commercetools.http.okhttp4.BuilderOptions;
import io.vrap.rmf.base.client.ApiHttpHeaders;
import io.vrap.rmf.base.client.ApiHttpRequest;
import io.vrap.rmf.base.client.ApiHttpResponse;
import io.vrap.rmf.base.client.VrapHttpClient;
import io.vrap.rmf.base.client.utils.Utils;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Dispatcher;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.BufferedSource;
import okio.GzipSource;
import okio.Okio;
import okio.Source;

public class CtOkHttp4Client
implements VrapHttpClient,
AutoCloseable {
    public static final int MAX_REQUESTS = 64;
    private final Supplier<OkHttpClient.Builder> clientBuilder = () -> new OkHttpClient.Builder().connectTimeout(120L, TimeUnit.SECONDS).writeTimeout(120L, TimeUnit.SECONDS).readTimeout(120L, TimeUnit.SECONDS).addInterceptor((Interceptor)new UnzippingInterceptor());
    private final OkHttpClient okHttpClient;
    private static final String CONTENT_TYPE = "Content-Type";
    private static final MediaType JSON = MediaType.get((String)"application/json; charset=utf-8");
    private static final byte[] emptyBody = new byte[0];

    public CtOkHttp4Client() {
        this.okHttpClient = this.clientBuilder.get().dispatcher(this.createDispatcher(64, 64)).build();
    }

    public CtOkHttp4Client(BuilderOptions options) {
        this.okHttpClient = options.plus(this.clientBuilder.get().dispatcher(this.createDispatcher(64, 64))).build();
    }

    public CtOkHttp4Client(Supplier<OkHttpClient.Builder> builderSupplier) {
        this.okHttpClient = builderSupplier.get().build();
    }

    public CtOkHttp4Client(int maxRequests, int maxRequestsPerHost) {
        this.okHttpClient = this.clientBuilder.get().dispatcher(this.createDispatcher(maxRequests, maxRequestsPerHost)).build();
    }

    public CtOkHttp4Client(ExecutorService executor, int maxRequests, int maxRequestsPerHost) {
        this.okHttpClient = this.clientBuilder.get().dispatcher(this.createDispatcher(executor, maxRequests, maxRequestsPerHost)).build();
    }

    private Dispatcher createDispatcher(int maxRequests, int maxRequestsPerHost) {
        Dispatcher dispatcher = new Dispatcher();
        dispatcher.setMaxRequests(maxRequests);
        dispatcher.setMaxRequestsPerHost(maxRequestsPerHost);
        return dispatcher;
    }

    private Dispatcher createDispatcher(ExecutorService executor, int maxRequests, int maxRequestsPerHost) {
        Dispatcher dispatcher = new Dispatcher(executor);
        dispatcher.setMaxRequests(maxRequests);
        dispatcher.setMaxRequestsPerHost(maxRequestsPerHost);
        return dispatcher;
    }

    public CompletableFuture<ApiHttpResponse<byte[]>> execute(ApiHttpRequest request) {
        return this.makeRequest(this.okHttpClient, CtOkHttp4Client.toRequest(request)).thenApply(CtOkHttp4Client::toResponse);
    }

    private static ApiHttpResponse<byte[]> toResponse(Response response) {
        ApiHttpHeaders apiHttpHeaders = new ApiHttpHeaders(response.headers().toMultimap().entrySet().stream().flatMap(e -> ((List)e.getValue()).stream().map(value -> ApiHttpHeaders.headerEntry((String)((String)e.getKey()), (String)value))).collect(Collectors.toList()));
        ApiHttpResponse apiHttpResponse = new ApiHttpResponse(response.code(), apiHttpHeaders, Optional.ofNullable(response.body()).map(Utils.wrapToCompletionException(ResponseBody::bytes)).orElse(null), response.message());
        if (apiHttpResponse.getBody() != null) {
            response.close();
        }
        return apiHttpResponse;
    }

    private static Request toRequest(ApiHttpRequest apiHttpRequest) {
        Request.Builder httpRequestBuilder = new Request.Builder().url(apiHttpRequest.getUrl());
        for (Map.Entry entry : apiHttpRequest.getHeaders().getHeaders()) {
            httpRequestBuilder = httpRequestBuilder.header((String)entry.getKey(), (String)entry.getValue());
        }
        if (apiHttpRequest.getMethod() == null) {
            throw new IllegalStateException("apiHttpRequest method should be non null");
        }
        MediaType mediaType = JSON;
        if (apiHttpRequest.getHeaders().getHeaders().stream().anyMatch(s -> ((String)s.getKey()).equalsIgnoreCase(CONTENT_TYPE))) {
            mediaType = MediaType.get((String)Objects.requireNonNull(apiHttpRequest.getHeaders().getFirst(CONTENT_TYPE)));
        }
        RequestBody body = apiHttpRequest.getBody() == null ? null : RequestBody.create((byte[])apiHttpRequest.getBody(), (MediaType)mediaType);
        httpRequestBuilder.method(apiHttpRequest.getMethod().name(), body);
        return httpRequestBuilder.build();
    }

    private CompletableFuture<Response> makeRequest(OkHttpClient client, Request request) {
        Call call = client.newCall(request);
        OkHttpResponseFuture result = new OkHttpResponseFuture();
        call.enqueue((Callback)result);
        return result.future;
    }

    @Override
    public void close() throws IOException {
        this.okHttpClient.dispatcher().executorService().shutdown();
        this.okHttpClient.connectionPool().evictAll();
        if (this.okHttpClient.cache() != null) {
            Objects.requireNonNull(this.okHttpClient.cache()).close();
        }
    }

    private static class UnzippingInterceptor
    implements Interceptor {
        private UnzippingInterceptor() {
        }

        @NotNull
        public Response intercept(Interceptor.Chain chain) throws IOException {
            Response response = chain.proceed(chain.request());
            return this.unzip(response);
        }

        private Response unzip(Response response) throws IOException {
            if (!"gzip".equalsIgnoreCase(response.header("Content-Encoding"))) {
                return response;
            }
            ResponseBody responseBody = response.body();
            if (responseBody == null) {
                return response;
            }
            GzipSource gzipSource = new GzipSource((Source)responseBody.source());
            Headers strippedHeaders = response.headers().newBuilder().removeAll("Content-Encoding").removeAll("Content-Length").build();
            String contentType = response.header(CtOkHttp4Client.CONTENT_TYPE);
            return response.newBuilder().headers(strippedHeaders).body(ResponseBody.create((BufferedSource)Okio.buffer((Source)gzipSource), (MediaType)MediaType.get((String)contentType), (long)-1L)).build();
        }
    }

    private static class OkHttpResponseFuture
    implements Callback {
        public final CompletableFuture<Response> future = new CompletableFuture();

        public void onFailure(Call call, IOException e) {
            this.future.completeExceptionally(e);
        }

        public void onResponse(Call call, Response response) throws IOException {
            this.future.complete(response);
        }
    }
}

