/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.http.netty;

import com.commercetools.http.netty.BuilderOptions;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelOption;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.resolver.AddressResolverGroup;
import io.netty.resolver.DefaultAddressResolverGroup;
import io.netty.util.AsciiString;
import io.vrap.rmf.base.client.ApiHttpHeaders;
import io.vrap.rmf.base.client.ApiHttpRequest;
import io.vrap.rmf.base.client.ApiHttpResponse;
import io.vrap.rmf.base.client.HttpClientBase;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.netty.ByteBufMono;
import reactor.netty.NettyOutbound;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.HttpClientRequest;
import reactor.netty.http.client.HttpClientResponse;
import reactor.netty.resources.ConnectionProvider;

public class CtNettyHttpClient
extends HttpClientBase {
    public static final int MAX_REQUESTS = 64;
    private static final byte[] EMPTY_BYTES = new byte[0];
    private final HttpClient nettyClient;

    public CtNettyHttpClient() {
        this(64);
    }

    public CtNettyHttpClient(int maxConnections) {
        this.nettyClient = CtNettyHttpClient.createDefaultClient(maxConnections);
        this.nettyClient.warmup();
    }

    public CtNettyHttpClient(BuilderOptions options) {
        this(64, options);
    }

    public CtNettyHttpClient(int maxConnections, BuilderOptions options) {
        this.nettyClient = options.plus(CtNettyHttpClient.createDefaultClient(maxConnections));
        this.nettyClient.warmup();
    }

    public CtNettyHttpClient(Supplier<HttpClient> httpClientSupplier) {
        this.nettyClient = httpClientSupplier.get();
        this.nettyClient.warmup();
    }

    public CtNettyHttpClient(ExecutorService executor) {
        this(executor, 64);
    }

    public CtNettyHttpClient(ExecutorService executor, int maxConnections) {
        super(executor);
        this.nettyClient = CtNettyHttpClient.createDefaultClient(maxConnections);
        this.nettyClient.warmup();
    }

    public CtNettyHttpClient(ExecutorService executor, BuilderOptions options) {
        this(executor, 64, options);
    }

    public CtNettyHttpClient(ExecutorService executor, int maxConnections, BuilderOptions options) {
        super(executor);
        this.nettyClient = options.plus(CtNettyHttpClient.createDefaultClient(maxConnections));
        this.nettyClient.warmup();
    }

    public CtNettyHttpClient(ExecutorService executor, Supplier<HttpClient> httpClientSupplier) {
        super(executor);
        this.nettyClient = httpClientSupplier.get();
        this.nettyClient.warmup();
    }

    public static HttpClient createDefaultClient(int maxConnections) {
        return (HttpClient)((HttpClient)HttpClient.create((ConnectionProvider)ConnectionProvider.create((String)"commercetools", (int)maxConnections)).secure().compress(true).resolver((AddressResolverGroup)DefaultAddressResolverGroup.INSTANCE)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)10000);
    }

    public CompletableFuture<ApiHttpResponse<byte[]>> execute(ApiHttpRequest request) {
        HttpMethod method = HttpMethod.valueOf((String)request.getMethod().name());
        return ((HttpClient.RequestSender)this.nettyClient.request(method).uri(request.getUri())).send(CtNettyHttpClient.toNettyRequest(request)).responseSingle(CtNettyHttpClient.toApiResponse()).toFuture().thenApplyAsync(Function.identity(), this.executor());
    }

    private static BiFunction<HttpClientRequest, NettyOutbound, Publisher<Void>> toNettyRequest(ApiHttpRequest httpRequest) {
        return (nettyRequest, nettyOutbound) -> {
            httpRequest.getHeaders().getHeaders().forEach(stringStringEntry -> nettyRequest.addHeader((CharSequence)stringStringEntry.getKey(), (CharSequence)stringStringEntry.getValue()));
            AsciiString mediaType = HttpHeaderValues.APPLICATION_JSON;
            if (httpRequest.getHeaders().getHeaders().stream().anyMatch(s -> ((String)s.getKey()).equalsIgnoreCase("Content-Type"))) {
                mediaType = AsciiString.of((CharSequence)Objects.requireNonNull(httpRequest.getHeaders().getFirst("Content-Type")));
            }
            nettyRequest.requestHeaders().set("Content-Type", (Object)mediaType);
            byte[] body = httpRequest.getBody();
            if (body != null) {
                return nettyOutbound.send((Publisher)Mono.just((Object)Unpooled.wrappedBuffer((byte[])body)));
            }
            return nettyOutbound;
        };
    }

    @NotNull
    private static BiFunction<HttpClientResponse, ByteBufMono, Mono<ApiHttpResponse<byte[]>>> toApiResponse() {
        return (response, byteBufMono) -> byteBufMono.asByteArray().defaultIfEmpty((Object)EMPTY_BYTES).map(bytes -> {
            ApiHttpHeaders headers = new ApiHttpHeaders(response.responseHeaders().entries());
            return new ApiHttpResponse(response.status().code(), headers, (Object)((byte[])(((byte[])bytes).length > 0 ? bytes : null)), response.status().reasonPhrase());
        });
    }

    protected void closeDelegate() throws Throwable {
    }
}

