/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.compat;

import com.commercetools.api.client.ByProjectKeyCartDiscountsGet;
import com.commercetools.api.client.ByProjectKeyCartsGet;
import com.commercetools.api.client.ByProjectKeyCategoriesGet;
import com.commercetools.api.client.ByProjectKeyChannelsGet;
import com.commercetools.api.client.ByProjectKeyCustomObjectsGet;
import com.commercetools.api.client.ByProjectKeyCustomerGroupsGet;
import com.commercetools.api.client.ByProjectKeyCustomersGet;
import com.commercetools.api.client.ByProjectKeyDiscountCodesGet;
import com.commercetools.api.client.ByProjectKeyExtensionsGet;
import com.commercetools.api.client.ByProjectKeyInventoryGet;
import com.commercetools.api.client.ByProjectKeyMessagesGet;
import com.commercetools.api.client.ByProjectKeyOrdersGet;
import com.commercetools.api.client.ByProjectKeyPaymentsGet;
import com.commercetools.api.client.ByProjectKeyProductDiscountsGet;
import com.commercetools.api.client.ByProjectKeyProductProjectionsGet;
import com.commercetools.api.client.ByProjectKeyProductTypesGet;
import com.commercetools.api.client.ByProjectKeyProductsGet;
import com.commercetools.api.client.ByProjectKeyReviewsGet;
import com.commercetools.api.client.ByProjectKeyShippingMethodsGet;
import com.commercetools.api.client.ByProjectKeyShoppingListsGet;
import com.commercetools.api.client.ByProjectKeyStatesGet;
import com.commercetools.api.client.ByProjectKeyStoresGet;
import com.commercetools.api.client.ByProjectKeySubscriptionsGet;
import com.commercetools.api.client.ByProjectKeyTaxCategoriesGet;
import com.commercetools.api.client.ByProjectKeyTypesGet;
import com.commercetools.api.client.ByProjectKeyZonesGet;
import com.commercetools.api.client.ProjectApiRoot;
import com.commercetools.api.client.SimplePagedQueryResourceRequest;
import io.sphere.sdk.cartdiscounts.queries.CartDiscountQuery;
import io.sphere.sdk.carts.queries.CartQuery;
import io.sphere.sdk.categories.queries.CategoryQuery;
import io.sphere.sdk.channels.queries.ChannelQuery;
import io.sphere.sdk.customergroups.queries.CustomerGroupQuery;
import io.sphere.sdk.customers.queries.CustomerQuery;
import io.sphere.sdk.customobjects.queries.CustomObjectQuery;
import io.sphere.sdk.discountcodes.queries.DiscountCodeQuery;
import io.sphere.sdk.expansion.ExpansionPath;
import io.sphere.sdk.extensions.queries.ExtensionQuery;
import io.sphere.sdk.inventory.queries.InventoryEntryQuery;
import io.sphere.sdk.messages.queries.MessageQuery;
import io.sphere.sdk.orders.queries.OrderQuery;
import io.sphere.sdk.payments.queries.PaymentQuery;
import io.sphere.sdk.productdiscounts.queries.ProductDiscountQuery;
import io.sphere.sdk.products.ProductProjectionType;
import io.sphere.sdk.products.queries.ProductProjectionQuery;
import io.sphere.sdk.products.queries.ProductQuery;
import io.sphere.sdk.producttypes.queries.ProductTypeQuery;
import io.sphere.sdk.queries.MetaModelQueryDsl;
import io.sphere.sdk.queries.QueryPredicate;
import io.sphere.sdk.queries.QuerySort;
import io.sphere.sdk.reviews.queries.ReviewQuery;
import io.sphere.sdk.shippingmethods.queries.ShippingMethodQuery;
import io.sphere.sdk.shoppinglists.queries.ShoppingListQuery;
import io.sphere.sdk.states.queries.StateQuery;
import io.sphere.sdk.stores.queries.StoreQuery;
import io.sphere.sdk.subscriptions.queries.SubscriptionQuery;
import io.sphere.sdk.taxcategories.queries.TaxCategoryQuery;
import io.sphere.sdk.types.queries.TypeQuery;
import io.sphere.sdk.zones.queries.ZoneQuery;
import java.util.function.Function;
import java.util.function.Supplier;

public class QueryBuilder {
    private final ProjectApiRoot apiRoot;

    private QueryBuilder(ProjectApiRoot apiRoot) {
        this.apiRoot = apiRoot;
    }

    public static QueryBuilder of(ProjectApiRoot apiRoot) {
        return new QueryBuilder(apiRoot);
    }

    public static <T extends SimplePagedQueryResourceRequest<T, TResult, ?>, TResult, TQuery extends MetaModelQueryDsl<?, ?, ?, ?>> T query(T request, TQuery queryDsl) {
        Object updatedRequest = queryDsl.limit() != null ? request.withLimit((Object)queryDsl.limit()) : request;
        updatedRequest = queryDsl.offset() != null ? updatedRequest.withOffset((Object)queryDsl.offset()) : updatedRequest;
        updatedRequest = queryDsl.fetchTotal() != null ? updatedRequest.withWithTotal((Object)queryDsl.fetchTotal()) : updatedRequest;
        for (QuerySort querySort : queryDsl.sort()) {
            updatedRequest = updatedRequest.addSort((Object)querySort.toSphereSort());
        }
        for (QueryPredicate queryPredicate : queryDsl.predicates()) {
            updatedRequest = updatedRequest.addWhere((Object)queryPredicate.toSphereQuery());
        }
        for (ExpansionPath expansionPath : queryDsl.expansionPaths()) {
            updatedRequest = updatedRequest.addWhere((Object)expansionPath.toSphereExpand());
        }
        return (T)updatedRequest.asPagedQueryResourceRequestToBaseType();
    }

    public static <T extends SimplePagedQueryResourceRequest<T, TResult, ?>, TResult, TQuery extends MetaModelQueryDsl<?, ?, ?, ?>> T query(T request, Supplier<TQuery> createQueryDsl, Function<TQuery, TQuery> queryDsl) {
        MetaModelQueryDsl query = (MetaModelQueryDsl)queryDsl.apply(createQueryDsl.get());
        return QueryBuilder.query(request, query);
    }

    public <T extends SimplePagedQueryResourceRequest<T, TResult, ?>, TResult, TQuery extends MetaModelQueryDsl<?, ?, ?, ?>> T with(Function<ProjectApiRoot, T> request, Supplier<TQuery> createQueryDsl, Function<TQuery, TQuery> queryDsl) {
        MetaModelQueryDsl query = (MetaModelQueryDsl)queryDsl.apply(createQueryDsl.get());
        return (T)QueryBuilder.query((SimplePagedQueryResourceRequest)request.apply(this.apiRoot), query);
    }

    public ByProjectKeyCartsGet cart(Function<CartQuery, CartQuery> queryDsl) {
        return this.with(queryDsl.apply(CartQuery.of()));
    }

    public ByProjectKeyCartsGet cart(Supplier<CartQuery> queryDsl) {
        return this.with(queryDsl.get());
    }

    public ByProjectKeyCartDiscountsGet cartDiscount(Function<CartDiscountQuery, CartDiscountQuery> queryDsl) {
        return this.with(queryDsl.apply(CartDiscountQuery.of()));
    }

    public ByProjectKeyCartDiscountsGet cartDiscount(Supplier<CartDiscountQuery> queryDsl) {
        return this.with(queryDsl.get());
    }

    @Deprecated
    public <T> ByProjectKeyCustomObjectsGet customObject(Class<T> valueClass, Function<CustomObjectQuery<T>, CustomObjectQuery<T>> queryDsl) {
        return this.with(queryDsl.apply(CustomObjectQuery.of(valueClass)));
    }

    @Deprecated
    public ByProjectKeyCustomObjectsGet customObject(Supplier<CustomObjectQuery<?>> queryDsl) {
        return this.with(queryDsl.get());
    }

    public ByProjectKeyCustomersGet customer(Function<CustomerQuery, CustomerQuery> queryDsl) {
        return this.with(queryDsl.apply(CustomerQuery.of()));
    }

    public ByProjectKeyCustomersGet customer(Supplier<CustomerQuery> queryDsl) {
        return this.with(queryDsl.get());
    }

    public ByProjectKeyDiscountCodesGet discountCode(Function<DiscountCodeQuery, DiscountCodeQuery> queryDsl) {
        return this.with(queryDsl.apply(DiscountCodeQuery.of()));
    }

    public ByProjectKeyDiscountCodesGet discountCode(Supplier<DiscountCodeQuery> queryDsl) {
        return this.with(queryDsl.get());
    }

    public ByProjectKeyCategoriesGet category(Function<CategoryQuery, CategoryQuery> queryDsl) {
        return this.with(queryDsl.apply(CategoryQuery.of()));
    }

    public ByProjectKeyCategoriesGet category(Supplier<CategoryQuery> queryDsl) {
        return this.with(queryDsl.get());
    }

    public ByProjectKeyChannelsGet channel(Function<ChannelQuery, ChannelQuery> queryDsl) {
        return this.with(queryDsl.apply(ChannelQuery.of()));
    }

    public ByProjectKeyChannelsGet channel(Supplier<ChannelQuery> queryDsl) {
        return this.with(queryDsl.get());
    }

    public ByProjectKeyProductsGet products(Function<ProductQuery, ProductQuery> queryDsl) {
        return this.with(queryDsl.apply(ProductQuery.of()));
    }

    public ByProjectKeyProductsGet products(Supplier<ProductQuery> queryDsl) {
        return this.with(queryDsl.get());
    }

    public ByProjectKeyProductProjectionsGet productProjections(Function<ProductProjectionQuery, ProductProjectionQuery> queryDsl) {
        return this.with(queryDsl.apply(ProductProjectionQuery.ofCurrent()));
    }

    public ByProjectKeyProductProjectionsGet productProjections(Supplier<ProductProjectionQuery> queryDsl) {
        return this.with(queryDsl.get());
    }

    public ByProjectKeyProductProjectionsGet productProjectionsStaged(Function<ProductProjectionQuery, ProductProjectionQuery> queryDsl) {
        return this.with(queryDsl.apply(ProductProjectionQuery.ofStaged()));
    }

    public ByProjectKeyProductProjectionsGet productProjections(ProductProjectionType type, Function<ProductProjectionQuery, ProductProjectionQuery> queryDsl) {
        return this.with(queryDsl.apply(ProductProjectionQuery.of((ProductProjectionType)type)));
    }

    public ByProjectKeyCustomerGroupsGet customerGroups(Function<CustomerGroupQuery, CustomerGroupQuery> queryDsl) {
        return this.with(queryDsl.apply(CustomerGroupQuery.of()));
    }

    public ByProjectKeyCustomerGroupsGet customerGroups(Supplier<CustomerGroupQuery> queryDsl) {
        return this.with(queryDsl.get());
    }

    public ByProjectKeyExtensionsGet extensions(Function<ExtensionQuery, ExtensionQuery> queryDsl) {
        return this.with(queryDsl.apply(ExtensionQuery.of()));
    }

    public ByProjectKeyExtensionsGet extensions(Supplier<ExtensionQuery> queryDsl) {
        return this.with(queryDsl.get());
    }

    public ByProjectKeyInventoryGet inventory(Function<InventoryEntryQuery, InventoryEntryQuery> queryDsl) {
        return this.with(queryDsl.apply(InventoryEntryQuery.of()));
    }

    public ByProjectKeyInventoryGet inventory(Supplier<InventoryEntryQuery> queryDsl) {
        return this.with(queryDsl.get());
    }

    public ByProjectKeyMessagesGet messages(Function<MessageQuery, MessageQuery> queryDsl) {
        return this.with(queryDsl.apply(MessageQuery.of()));
    }

    public ByProjectKeyMessagesGet messages(Supplier<MessageQuery> queryDsl) {
        return this.with(queryDsl.get());
    }

    public ByProjectKeyOrdersGet orders(Function<OrderQuery, OrderQuery> queryDsl) {
        return this.with(queryDsl.apply(OrderQuery.of()));
    }

    public ByProjectKeyOrdersGet orders(Supplier<OrderQuery> queryDsl) {
        return this.with(queryDsl.get());
    }

    public ByProjectKeyPaymentsGet payments(Function<PaymentQuery, PaymentQuery> queryDsl) {
        return this.with(queryDsl.apply(PaymentQuery.of()));
    }

    public ByProjectKeyPaymentsGet payments(Supplier<PaymentQuery> queryDsl) {
        return this.with(queryDsl.get());
    }

    public ByProjectKeyProductDiscountsGet productDiscounts(Function<ProductDiscountQuery, ProductDiscountQuery> queryDsl) {
        return this.with(queryDsl.apply(ProductDiscountQuery.of()));
    }

    public ByProjectKeyProductDiscountsGet productDiscounts(Supplier<ProductDiscountQuery> queryDsl) {
        return this.with(queryDsl.get());
    }

    public ByProjectKeyProductTypesGet productTypes(Function<ProductTypeQuery, ProductTypeQuery> queryDsl) {
        return this.with(queryDsl.apply(ProductTypeQuery.of()));
    }

    public ByProjectKeyProductTypesGet productTypes(Supplier<ProductTypeQuery> queryDsl) {
        return this.with(queryDsl.get());
    }

    public ByProjectKeyReviewsGet review(Function<ReviewQuery, ReviewQuery> queryDsl) {
        return this.with(queryDsl.apply(ReviewQuery.of()));
    }

    public ByProjectKeyReviewsGet review(Supplier<ReviewQuery> queryDsl) {
        return this.with(queryDsl.get());
    }

    public ByProjectKeyShippingMethodsGet shippingMethods(Function<ShippingMethodQuery, ShippingMethodQuery> queryDsl) {
        return this.with(queryDsl.apply(ShippingMethodQuery.of()));
    }

    public ByProjectKeyShippingMethodsGet shippingMethods(Supplier<ShippingMethodQuery> queryDsl) {
        return this.with(queryDsl.get());
    }

    public ByProjectKeyShoppingListsGet shoppingLists(Function<ShoppingListQuery, ShoppingListQuery> queryDsl) {
        return this.with(queryDsl.apply(ShoppingListQuery.of()));
    }

    public ByProjectKeyShoppingListsGet shoppingLists(Supplier<ShoppingListQuery> queryDsl) {
        return this.with(queryDsl.get());
    }

    public ByProjectKeyStatesGet states(Function<StateQuery, StateQuery> queryDsl) {
        return this.with(queryDsl.apply(StateQuery.of()));
    }

    public ByProjectKeyStatesGet states(Supplier<StateQuery> queryDsl) {
        return this.with(queryDsl.get());
    }

    public ByProjectKeyStoresGet stores(Function<StoreQuery, StoreQuery> queryDsl) {
        return this.with(queryDsl.apply(StoreQuery.of()));
    }

    public ByProjectKeyStoresGet stores(Supplier<StoreQuery> queryDsl) {
        return this.with(queryDsl.get());
    }

    public ByProjectKeySubscriptionsGet subscriptions(Function<SubscriptionQuery, SubscriptionQuery> queryDsl) {
        return this.with(queryDsl.apply(SubscriptionQuery.of()));
    }

    public ByProjectKeySubscriptionsGet subscriptions(Supplier<SubscriptionQuery> queryDsl) {
        return this.with(queryDsl.get());
    }

    public ByProjectKeyTaxCategoriesGet taxCategories(Function<TaxCategoryQuery, TaxCategoryQuery> queryDsl) {
        return this.with(queryDsl.apply(TaxCategoryQuery.of()));
    }

    public ByProjectKeyTaxCategoriesGet taxCategories(Supplier<TaxCategoryQuery> queryDsl) {
        return this.with(queryDsl.get());
    }

    public ByProjectKeyZonesGet zones(Function<ZoneQuery, ZoneQuery> queryDsl) {
        return this.with(queryDsl.apply(ZoneQuery.of()));
    }

    public ByProjectKeyZonesGet zones(Supplier<ZoneQuery> queryDsl) {
        return this.with(queryDsl.get());
    }

    public ByProjectKeyTypesGet types(Function<TypeQuery, TypeQuery> queryDsl) {
        return this.with(queryDsl.apply(TypeQuery.of()));
    }

    public ByProjectKeyTypesGet types(Supplier<TypeQuery> queryDsl) {
        return this.with(queryDsl.get());
    }

    @Deprecated
    public ByProjectKeyCartsGet cart(CartQuery queryDsl) {
        return this.with(queryDsl);
    }

    @Deprecated
    public ByProjectKeyCartDiscountsGet cartDiscount(CartDiscountQuery queryDsl) {
        return this.with(queryDsl);
    }

    @Deprecated
    public ByProjectKeyCustomObjectsGet customObject(CustomObjectQuery<?> queryDsl) {
        return this.with(queryDsl);
    }

    @Deprecated
    public ByProjectKeyCustomersGet customer(CustomerQuery queryDsl) {
        return this.with(queryDsl);
    }

    @Deprecated
    public ByProjectKeyDiscountCodesGet discountCode(DiscountCodeQuery queryDsl) {
        return this.with(queryDsl);
    }

    @Deprecated
    public ByProjectKeyCategoriesGet category(CategoryQuery queryDsl) {
        return this.with(queryDsl);
    }

    @Deprecated
    public ByProjectKeyChannelsGet channel(ChannelQuery queryDsl) {
        return this.with(queryDsl);
    }

    @Deprecated
    public ByProjectKeyProductsGet products(ProductQuery queryDsl) {
        return this.with(queryDsl);
    }

    @Deprecated
    public ByProjectKeyProductProjectionsGet productProjections(ProductProjectionQuery queryDsl) {
        return this.with(queryDsl);
    }

    @Deprecated
    public ByProjectKeyCustomerGroupsGet customerGroups(CustomerGroupQuery queryDsl) {
        return this.with(queryDsl);
    }

    @Deprecated
    public ByProjectKeyExtensionsGet extensions(ExtensionQuery queryDsl) {
        return this.with(queryDsl);
    }

    @Deprecated
    public ByProjectKeyInventoryGet inventory(InventoryEntryQuery queryDsl) {
        return this.with(queryDsl);
    }

    @Deprecated
    public ByProjectKeyMessagesGet messages(MessageQuery queryDsl) {
        return this.with(queryDsl);
    }

    @Deprecated
    public ByProjectKeyOrdersGet orders(OrderQuery queryDsl) {
        return this.with(queryDsl);
    }

    @Deprecated
    public ByProjectKeyPaymentsGet payments(PaymentQuery queryDsl) {
        return this.with(queryDsl);
    }

    @Deprecated
    public ByProjectKeyProductDiscountsGet productDiscounts(ProductDiscountQuery queryDsl) {
        return this.with(queryDsl);
    }

    @Deprecated
    public ByProjectKeyProductTypesGet productTypes(ProductTypeQuery queryDsl) {
        return this.with(queryDsl);
    }

    @Deprecated
    public ByProjectKeyReviewsGet review(ReviewQuery queryDsl) {
        return this.with(queryDsl);
    }

    @Deprecated
    public ByProjectKeyShippingMethodsGet shippingMethods(ShippingMethodQuery queryDsl) {
        return this.with(queryDsl);
    }

    @Deprecated
    public ByProjectKeyShoppingListsGet shoppingLists(ShoppingListQuery queryDsl) {
        return this.with(queryDsl);
    }

    @Deprecated
    public ByProjectKeyStatesGet states(StateQuery queryDsl) {
        return this.with(queryDsl);
    }

    @Deprecated
    public ByProjectKeyStoresGet stores(StoreQuery queryDsl) {
        return this.with(queryDsl);
    }

    @Deprecated
    public ByProjectKeySubscriptionsGet subscriptions(SubscriptionQuery queryDsl) {
        return this.with(queryDsl);
    }

    @Deprecated
    public ByProjectKeyTaxCategoriesGet taxCategories(TaxCategoryQuery queryDsl) {
        return this.with(queryDsl);
    }

    @Deprecated
    public ByProjectKeyZonesGet zones(ZoneQuery queryDsl) {
        return this.with(queryDsl);
    }

    @Deprecated
    public ByProjectKeyTypesGet types(TypeQuery queryDsl) {
        return this.with(queryDsl);
    }

    public ByProjectKeyCartsGet with(CartQuery queryDsl) {
        return QueryBuilder.query(this.apiRoot.carts().get(), queryDsl);
    }

    public ByProjectKeyCartDiscountsGet with(CartDiscountQuery queryDsl) {
        return QueryBuilder.query(this.apiRoot.cartDiscounts().get(), queryDsl);
    }

    @Deprecated
    public ByProjectKeyCustomObjectsGet with(CustomObjectQuery<?> queryDsl) {
        return QueryBuilder.query(this.apiRoot.customObjects().get(), queryDsl);
    }

    public ByProjectKeyCustomersGet with(CustomerQuery queryDsl) {
        return QueryBuilder.query(this.apiRoot.customers().get(), queryDsl);
    }

    public ByProjectKeyDiscountCodesGet with(DiscountCodeQuery queryDsl) {
        return QueryBuilder.query(this.apiRoot.discountCodes().get(), queryDsl);
    }

    public ByProjectKeyCategoriesGet with(CategoryQuery queryDsl) {
        return QueryBuilder.query(this.apiRoot.categories().get(), queryDsl);
    }

    public ByProjectKeyChannelsGet with(ChannelQuery queryDsl) {
        return QueryBuilder.query(this.apiRoot.channels().get(), queryDsl);
    }

    public ByProjectKeyProductsGet with(ProductQuery queryDsl) {
        return QueryBuilder.query(this.apiRoot.products().get(), queryDsl);
    }

    public ByProjectKeyProductProjectionsGet with(ProductProjectionQuery queryDsl) {
        return QueryBuilder.query(this.apiRoot.productProjections().get(), queryDsl);
    }

    public ByProjectKeyCustomerGroupsGet with(CustomerGroupQuery queryDsl) {
        return QueryBuilder.query(this.apiRoot.customerGroups().get(), queryDsl);
    }

    public ByProjectKeyExtensionsGet with(ExtensionQuery queryDsl) {
        return QueryBuilder.query(this.apiRoot.extensions().get(), queryDsl);
    }

    public ByProjectKeyInventoryGet with(InventoryEntryQuery queryDsl) {
        return QueryBuilder.query(this.apiRoot.inventory().get(), queryDsl);
    }

    public ByProjectKeyMessagesGet with(MessageQuery queryDsl) {
        return QueryBuilder.query(this.apiRoot.messages().get(), queryDsl);
    }

    public ByProjectKeyOrdersGet with(OrderQuery queryDsl) {
        return QueryBuilder.query(this.apiRoot.orders().get(), queryDsl);
    }

    public ByProjectKeyPaymentsGet with(PaymentQuery queryDsl) {
        return QueryBuilder.query(this.apiRoot.payments().get(), queryDsl);
    }

    public ByProjectKeyProductDiscountsGet with(ProductDiscountQuery queryDsl) {
        return QueryBuilder.query(this.apiRoot.productDiscounts().get(), queryDsl);
    }

    public ByProjectKeyProductTypesGet with(ProductTypeQuery queryDsl) {
        return QueryBuilder.query(this.apiRoot.productTypes().get(), queryDsl);
    }

    public ByProjectKeyReviewsGet with(ReviewQuery queryDsl) {
        return QueryBuilder.query(this.apiRoot.reviews().get(), queryDsl);
    }

    public ByProjectKeyShippingMethodsGet with(ShippingMethodQuery queryDsl) {
        return QueryBuilder.query(this.apiRoot.shippingMethods().get(), queryDsl);
    }

    public ByProjectKeyShoppingListsGet with(ShoppingListQuery queryDsl) {
        return QueryBuilder.query(this.apiRoot.shoppingLists().get(), queryDsl);
    }

    public ByProjectKeyStatesGet with(StateQuery queryDsl) {
        return QueryBuilder.query(this.apiRoot.states().get(), queryDsl);
    }

    public ByProjectKeyStoresGet with(StoreQuery queryDsl) {
        return QueryBuilder.query(this.apiRoot.stores().get(), queryDsl);
    }

    public ByProjectKeySubscriptionsGet with(SubscriptionQuery queryDsl) {
        return QueryBuilder.query(this.apiRoot.subscriptions().get(), queryDsl);
    }

    public ByProjectKeyTaxCategoriesGet with(TaxCategoryQuery queryDsl) {
        return QueryBuilder.query(this.apiRoot.taxCategories().get(), queryDsl);
    }

    public ByProjectKeyZonesGet with(ZoneQuery queryDsl) {
        return QueryBuilder.query(this.apiRoot.zones().get(), queryDsl);
    }

    public ByProjectKeyTypesGet with(TypeQuery queryDsl) {
        return QueryBuilder.query(this.apiRoot.types().get(), queryDsl);
    }
}

