/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.compat;

import io.sphere.sdk.client.SphereRequest;
import io.sphere.sdk.http.FormUrlEncodedHttpRequestBody;
import io.sphere.sdk.http.HttpException;
import io.sphere.sdk.http.HttpRequest;
import io.sphere.sdk.http.StringHttpRequestBody;
import io.vrap.rmf.base.client.ApiHttpClient;
import io.vrap.rmf.base.client.ApiHttpHeaders;
import io.vrap.rmf.base.client.ApiHttpMethod;
import io.vrap.rmf.base.client.ApiHttpRequest;
import io.vrap.rmf.base.client.ApiHttpResponse;
import io.vrap.rmf.base.client.ApiMethod;
import io.vrap.rmf.base.client.ClientRequestCommand;
import io.vrap.rmf.base.client.utils.ClientUtils;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class CompatRequest<TResult>
extends ApiMethod<CompatRequest<TResult>, TResult>
implements ClientRequestCommand<TResult> {
    private final SphereRequest<?> request;
    private final Class<TResult> resultClass;
    private final String projectKey;

    private CompatRequest(ApiHttpClient apiHttpClient, String projectKey, SphereRequest<?> request, Class<TResult> resultClass) {
        super(apiHttpClient);
        this.request = request;
        this.projectKey = projectKey;
        this.resultClass = resultClass;
    }

    private CompatRequest(CompatRequest<TResult> t) {
        super(t);
        this.request = t.request;
        this.resultClass = t.resultClass;
        this.projectKey = t.projectKey;
    }

    public static <TResult> CompatRequest<TResult> of(ApiHttpClient client, String projectKey, SphereRequest<?> request, Class<TResult> resultClass) {
        return new CompatRequest<TResult>(client, projectKey, request, resultClass);
    }

    protected CompatRequest<TResult> copy() {
        return new CompatRequest<TResult>(this);
    }

    public ApiHttpRequest createHttpRequest() {
        HttpRequest httpRequest = this.request.httpRequestIntent().toHttpRequest("/" + this.projectKey);
        List headers = httpRequest.getHeaders().getHeadersAsMap().entrySet().stream().flatMap(e -> ((List)e.getValue()).stream().map(v -> new AbstractMap.SimpleEntry<String, String>((String)e.getKey(), v){})).collect(Collectors.toList());
        URI resolve = URI.create(httpRequest.getUrl());
        return new ApiHttpRequest(ApiHttpMethod.valueOf((String)httpRequest.getHttpMethod().name()), resolve, new ApiHttpHeaders(headers), (byte[])Optional.ofNullable(httpRequest.getBody()).map(body -> {
            if (body instanceof StringHttpRequestBody) {
                return ((StringHttpRequestBody)body).getString().getBytes(StandardCharsets.UTF_8);
            }
            if (body instanceof FormUrlEncodedHttpRequestBody) {
                return CompatRequest.urlEncodedOf((FormUrlEncodedHttpRequestBody)body).getBytes(StandardCharsets.UTF_8);
            }
            throw new HttpException("Cannot interpret request " + httpRequest);
        }).orElse(null));
    }

    private static String urlEncodedOf(FormUrlEncodedHttpRequestBody body) {
        return body.getParameters().stream().map(entry -> {
            try {
                return entry.getName() + "=" + URLEncoder.encode(entry.getValue(), StandardCharsets.UTF_8.toString());
            }
            catch (UnsupportedEncodingException e) {
                throw new HttpException("Cannot encode request body " + body, (Throwable)e);
            }
        }).collect(Collectors.joining("&"));
    }

    public ApiHttpResponse<TResult> executeBlocking(ApiHttpClient client, Duration timeout) {
        return (ApiHttpResponse)ClientUtils.blockingWait(this.execute(client), (Duration)timeout);
    }

    public CompletableFuture<ApiHttpResponse<TResult>> execute(ApiHttpClient client) {
        return client.execute(this.createHttpRequest(), this.resultClass);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        CompatRequest request1 = (CompatRequest)((Object)o);
        return new EqualsBuilder().append(this.request, request1.request).append(this.resultClass, request1.resultClass).append((Object)this.projectKey, (Object)request1.projectKey).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.request).append(this.resultClass).append((Object)this.projectKey).toHashCode();
    }
}

