/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.compat;

import com.commercetools.api.defaultconfig.ApiRootBuilder;
import com.commercetools.compat.CompatRequest;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.sphere.sdk.client.SphereApiConfig;
import io.sphere.sdk.client.SphereClient;
import io.sphere.sdk.client.SphereClientConfig;
import io.sphere.sdk.client.SphereRequest;
import io.sphere.sdk.http.HttpRequest;
import io.sphere.sdk.http.HttpResponse;
import io.sphere.sdk.json.SphereJsonUtils;
import io.vrap.rmf.base.client.ApiHttpClient;
import io.vrap.rmf.base.client.AutoCloseableService;
import io.vrap.rmf.base.client.ResponseSerializer;
import io.vrap.rmf.base.client.oauth2.ClientCredentials;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public class CompatSphereClient
extends AutoCloseableService
implements SphereClient {
    private final ApiHttpClient client;
    private final SphereClientConfig clientConfig;

    private CompatSphereClient(SphereClientConfig clientConfig) {
        URI resolve = URI.create(clientConfig.getApiUrl()).resolve("/" + clientConfig.getProjectKey() + "/");
        this.client = ApiRootBuilder.of().defaultClient(resolve).addCorrelationIdProvider(() -> clientConfig.getCorrelationIdGenerator().get()).withClientCredentialsFlow((ClientCredentials)ClientCredentials.of().withClientId(clientConfig.getClientId()).withClientSecret(clientConfig.getClientSecret()).build(), URI.create(clientConfig.getAuthUrl()).resolve("/oauth/token")).withSerializer(ResponseSerializer.of((ObjectMapper)SphereJsonUtils.newObjectMapper())).buildClient();
        this.clientConfig = clientConfig;
    }

    public static CompatSphereClient of(SphereClientConfig clientConfig) {
        return new CompatSphereClient(clientConfig);
    }

    public <T> CompletionStage<T> execute(SphereRequest<T> sphereRequest) {
        CompatRequest<JsonNode> compatRequest = CompatRequest.of(this.client, this.clientConfig.getProjectKey(), sphereRequest, JsonNode.class);
        return ((CompletableFuture)compatRequest.send().thenApply(apiHttpResponse -> HttpResponse.of((Integer)apiHttpResponse.getStatusCode(), (byte[])((byte[])apiHttpResponse.getBody()), (HttpRequest)sphereRequest.httpRequestIntent().toHttpRequest(this.clientConfig.getApiUrl())))).thenApply(arg_0 -> sphereRequest.deserialize(arg_0));
    }

    protected void internalClose() {
        CompatSphereClient.closeQuietly((AutoCloseable)this.client);
    }

    public SphereApiConfig getConfig() {
        return this.clientConfig;
    }
}

