/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.compat;

import com.commercetools.api.client.ByProjectKeyCartDiscountsGet;
import com.commercetools.api.client.ByProjectKeyCartsGet;
import com.commercetools.api.client.ByProjectKeyCategoriesGet;
import com.commercetools.api.client.ByProjectKeyChannelsGet;
import com.commercetools.api.client.ByProjectKeyCustomerGroupsGet;
import com.commercetools.api.client.ByProjectKeyCustomersGet;
import com.commercetools.api.client.ByProjectKeyDiscountCodesGet;
import com.commercetools.api.client.ByProjectKeyExtensionsGet;
import com.commercetools.api.client.ByProjectKeyInventoryGet;
import com.commercetools.api.client.ByProjectKeyMessagesGet;
import com.commercetools.api.client.ByProjectKeyOrdersGet;
import com.commercetools.api.client.ByProjectKeyPaymentsGet;
import com.commercetools.api.client.ByProjectKeyProductDiscountsGet;
import com.commercetools.api.client.ByProjectKeyProductProjectionsGet;
import com.commercetools.api.client.ByProjectKeyProductTypesGet;
import com.commercetools.api.client.ByProjectKeyProductsGet;
import com.commercetools.api.client.ByProjectKeyReviewsGet;
import com.commercetools.api.client.ByProjectKeyShippingMethodsGet;
import com.commercetools.api.client.ByProjectKeyShoppingListsGet;
import com.commercetools.api.client.ByProjectKeyStatesGet;
import com.commercetools.api.client.ByProjectKeyStoresGet;
import com.commercetools.api.client.ByProjectKeySubscriptionsGet;
import com.commercetools.api.client.ByProjectKeyTaxCategoriesGet;
import com.commercetools.api.client.ByProjectKeyTypesGet;
import com.commercetools.api.client.ByProjectKeyZonesGet;
import com.commercetools.api.client.ProjectApiRoot;
import com.commercetools.api.models.PagedQueryResourceRequest;
import io.sphere.sdk.cartdiscounts.queries.CartDiscountQuery;
import io.sphere.sdk.carts.queries.CartQuery;
import io.sphere.sdk.categories.queries.CategoryQuery;
import io.sphere.sdk.channels.queries.ChannelQuery;
import io.sphere.sdk.customergroups.queries.CustomerGroupQuery;
import io.sphere.sdk.customers.queries.CustomerQuery;
import io.sphere.sdk.discountcodes.queries.DiscountCodeQuery;
import io.sphere.sdk.expansion.ExpansionPath;
import io.sphere.sdk.extensions.queries.ExtensionQuery;
import io.sphere.sdk.inventory.queries.InventoryEntryQuery;
import io.sphere.sdk.messages.queries.MessageQuery;
import io.sphere.sdk.orders.queries.OrderQuery;
import io.sphere.sdk.payments.queries.PaymentQuery;
import io.sphere.sdk.productdiscounts.queries.ProductDiscountQuery;
import io.sphere.sdk.products.ProductProjectionType;
import io.sphere.sdk.products.queries.ProductProjectionQuery;
import io.sphere.sdk.products.queries.ProductQuery;
import io.sphere.sdk.producttypes.queries.ProductTypeQuery;
import io.sphere.sdk.queries.MetaModelQueryDsl;
import io.sphere.sdk.queries.QueryPredicate;
import io.sphere.sdk.queries.QuerySort;
import io.sphere.sdk.reviews.queries.ReviewQuery;
import io.sphere.sdk.shippingmethods.queries.ShippingMethodQuery;
import io.sphere.sdk.shoppinglists.queries.ShoppingListQuery;
import io.sphere.sdk.states.queries.StateQuery;
import io.sphere.sdk.stores.queries.StoreQuery;
import io.sphere.sdk.subscriptions.queries.SubscriptionQuery;
import io.sphere.sdk.taxcategories.queries.TaxCategoryQuery;
import io.sphere.sdk.types.queries.TypeQuery;
import io.sphere.sdk.zones.queries.ZoneQuery;
import java.util.function.Function;
import java.util.function.Supplier;

public class QueryBuilder {
    private final ProjectApiRoot apiRoot;

    private QueryBuilder(ProjectApiRoot apiRoot) {
        this.apiRoot = apiRoot;
    }

    public static QueryBuilder of(ProjectApiRoot apiRoot) {
        return new QueryBuilder(apiRoot);
    }

    public static <T extends PagedQueryResourceRequest<T, TResult>, TResult, TQuery extends MetaModelQueryDsl<?, ?, ?, ?>> T query(T request, TQuery queryDsl) {
        Object updatedRequest = queryDsl.limit() != null ? request.withLimit((Object)queryDsl.limit()) : request;
        updatedRequest = queryDsl.offset() != null ? updatedRequest.withOffset((Object)queryDsl.offset()) : updatedRequest;
        updatedRequest = queryDsl.fetchTotal() != null ? updatedRequest.withWithTotal((Object)queryDsl.fetchTotal()) : updatedRequest;
        for (QuerySort querySort : queryDsl.sort()) {
            updatedRequest = updatedRequest.addSort((Object)querySort.toSphereSort());
        }
        for (QueryPredicate queryPredicate : queryDsl.predicates()) {
            updatedRequest = updatedRequest.addWhere((Object)queryPredicate.toSphereQuery());
        }
        for (ExpansionPath expansionPath : queryDsl.expansionPaths()) {
            updatedRequest = updatedRequest.addWhere((Object)expansionPath.toSphereExpand());
        }
        return (T)updatedRequest.asPagedQueryResourceRequestToBaseType();
    }

    public static <T extends PagedQueryResourceRequest<T, TResult>, TResult, TQuery extends MetaModelQueryDsl<?, ?, ?, ?>> T query(T request, Supplier<TQuery> createQueryDsl, Function<TQuery, TQuery> queryDsl) {
        MetaModelQueryDsl query = (MetaModelQueryDsl)queryDsl.apply(createQueryDsl.get());
        return QueryBuilder.query(request, query);
    }

    public <T extends PagedQueryResourceRequest<T, TResult>, TResult, TQuery extends MetaModelQueryDsl<?, ?, ?, ?>> T with(Function<ProjectApiRoot, T> request, Supplier<TQuery> createQueryDsl, Function<TQuery, TQuery> queryDsl) {
        MetaModelQueryDsl query = (MetaModelQueryDsl)queryDsl.apply(createQueryDsl.get());
        return (T)QueryBuilder.query((PagedQueryResourceRequest)request.apply(this.apiRoot), query);
    }

    public ByProjectKeyCartsGet cart(Function<CartQuery, CartQuery> queryDsl) {
        return QueryBuilder.query(this.apiRoot.carts().get(), CartQuery::of, queryDsl);
    }

    public ByProjectKeyCartDiscountsGet cartDiscount(Function<CartDiscountQuery, CartDiscountQuery> queryDsl) {
        return QueryBuilder.query(this.apiRoot.cartDiscounts().get(), CartDiscountQuery::of, queryDsl);
    }

    public ByProjectKeyCartDiscountsGet customObject(Function<CartDiscountQuery, CartDiscountQuery> queryDsl) {
        return QueryBuilder.query(this.apiRoot.cartDiscounts().get(), CartDiscountQuery::of, queryDsl);
    }

    public ByProjectKeyCustomersGet customer(Function<CustomerQuery, CustomerQuery> queryDsl) {
        return QueryBuilder.query(this.apiRoot.customers().get(), CustomerQuery::of, queryDsl);
    }

    public ByProjectKeyDiscountCodesGet discountCode(Function<DiscountCodeQuery, DiscountCodeQuery> queryDsl) {
        return QueryBuilder.query(this.apiRoot.discountCodes().get(), DiscountCodeQuery::of, queryDsl);
    }

    public ByProjectKeyCategoriesGet category(Function<CategoryQuery, CategoryQuery> queryDsl) {
        return QueryBuilder.query(this.apiRoot.categories().get(), CategoryQuery::of, queryDsl);
    }

    public ByProjectKeyChannelsGet channel(Function<ChannelQuery, ChannelQuery> queryDsl) {
        return QueryBuilder.query(this.apiRoot.channels().get(), ChannelQuery::of, queryDsl);
    }

    public ByProjectKeyProductsGet products(Function<ProductQuery, ProductQuery> queryDsl) {
        return QueryBuilder.query(this.apiRoot.products().get(), ProductQuery::of, queryDsl);
    }

    public ByProjectKeyProductProjectionsGet productProjections(Function<ProductProjectionQuery, ProductProjectionQuery> queryDsl) {
        return QueryBuilder.query(this.apiRoot.productProjections().get(), ProductProjectionQuery::ofCurrent, queryDsl);
    }

    public ByProjectKeyProductProjectionsGet productProjectionsStaged(Function<ProductProjectionQuery, ProductProjectionQuery> queryDsl) {
        return QueryBuilder.query(this.apiRoot.productProjections().get(), ProductProjectionQuery::ofStaged, queryDsl);
    }

    public ByProjectKeyProductProjectionsGet productProjections(ProductProjectionType type, Function<ProductProjectionQuery, ProductProjectionQuery> queryDsl) {
        return QueryBuilder.query(this.apiRoot.productProjections().get(), () -> ProductProjectionQuery.of((ProductProjectionType)type), queryDsl);
    }

    public ByProjectKeyCustomerGroupsGet customerGroups(Function<CustomerGroupQuery, CustomerGroupQuery> queryDsl) {
        return QueryBuilder.query(this.apiRoot.customerGroups().get(), CustomerGroupQuery::of, queryDsl);
    }

    public ByProjectKeyExtensionsGet extensions(Function<ExtensionQuery, ExtensionQuery> queryDsl) {
        return QueryBuilder.query(this.apiRoot.extensions().get(), ExtensionQuery::of, queryDsl);
    }

    public ByProjectKeyInventoryGet inventory(Function<InventoryEntryQuery, InventoryEntryQuery> queryDsl) {
        return QueryBuilder.query(this.apiRoot.inventory().get(), InventoryEntryQuery::of, queryDsl);
    }

    public ByProjectKeyMessagesGet messages(Function<MessageQuery, MessageQuery> queryDsl) {
        return QueryBuilder.query(this.apiRoot.messages().get(), MessageQuery::of, queryDsl);
    }

    public ByProjectKeyOrdersGet orders(Function<OrderQuery, OrderQuery> queryDsl) {
        return QueryBuilder.query(this.apiRoot.orders().get(), OrderQuery::of, queryDsl);
    }

    public ByProjectKeyPaymentsGet payments(Function<PaymentQuery, PaymentQuery> queryDsl) {
        return QueryBuilder.query(this.apiRoot.payments().get(), PaymentQuery::of, queryDsl);
    }

    public ByProjectKeyProductDiscountsGet productDiscounts(Function<ProductDiscountQuery, ProductDiscountQuery> queryDsl) {
        return QueryBuilder.query(this.apiRoot.productDiscounts().get(), ProductDiscountQuery::of, queryDsl);
    }

    public ByProjectKeyProductTypesGet productTypes(Function<ProductTypeQuery, ProductTypeQuery> queryDsl) {
        return QueryBuilder.query(this.apiRoot.productTypes().get(), ProductTypeQuery::of, queryDsl);
    }

    public ByProjectKeyReviewsGet review(Function<ReviewQuery, ReviewQuery> queryDsl) {
        return QueryBuilder.query(this.apiRoot.reviews().get(), ReviewQuery::of, queryDsl);
    }

    public ByProjectKeyShippingMethodsGet shippingMethods(Function<ShippingMethodQuery, ShippingMethodQuery> queryDsl) {
        return QueryBuilder.query(this.apiRoot.shippingMethods().get(), ShippingMethodQuery::of, queryDsl);
    }

    public ByProjectKeyShoppingListsGet shoppingLists(Function<ShoppingListQuery, ShoppingListQuery> queryDsl) {
        return QueryBuilder.query(this.apiRoot.shoppingLists().get(), ShoppingListQuery::of, queryDsl);
    }

    public ByProjectKeyStatesGet states(Function<StateQuery, StateQuery> queryDsl) {
        return QueryBuilder.query(this.apiRoot.states().get(), StateQuery::of, queryDsl);
    }

    public ByProjectKeyStoresGet stores(Function<StoreQuery, StoreQuery> queryDsl) {
        return QueryBuilder.query(this.apiRoot.stores().get(), StoreQuery::of, queryDsl);
    }

    public ByProjectKeySubscriptionsGet subscriptions(Function<SubscriptionQuery, SubscriptionQuery> queryDsl) {
        return QueryBuilder.query(this.apiRoot.subscriptions().get(), SubscriptionQuery::of, queryDsl);
    }

    public ByProjectKeyTaxCategoriesGet taxCategories(Function<TaxCategoryQuery, TaxCategoryQuery> queryDsl) {
        return QueryBuilder.query(this.apiRoot.taxCategories().get(), TaxCategoryQuery::of, queryDsl);
    }

    public ByProjectKeyZonesGet zones(Function<ZoneQuery, ZoneQuery> queryDsl) {
        return QueryBuilder.query(this.apiRoot.zones().get(), ZoneQuery::of, queryDsl);
    }

    public ByProjectKeyTypesGet types(Function<TypeQuery, TypeQuery> queryDsl) {
        return QueryBuilder.query(this.apiRoot.types().get(), TypeQuery::of, queryDsl);
    }

    public ByProjectKeyCartsGet cart(CartQuery queryDsl) {
        return QueryBuilder.query(this.apiRoot.carts().get(), queryDsl);
    }

    public ByProjectKeyCartDiscountsGet cartDiscount(CartDiscountQuery queryDsl) {
        return QueryBuilder.query(this.apiRoot.cartDiscounts().get(), queryDsl);
    }

    public ByProjectKeyCartDiscountsGet customObject(CartDiscountQuery queryDsl) {
        return QueryBuilder.query(this.apiRoot.cartDiscounts().get(), queryDsl);
    }

    public ByProjectKeyCustomersGet customer(CustomerQuery queryDsl) {
        return QueryBuilder.query(this.apiRoot.customers().get(), queryDsl);
    }

    public ByProjectKeyDiscountCodesGet discountCode(DiscountCodeQuery queryDsl) {
        return QueryBuilder.query(this.apiRoot.discountCodes().get(), queryDsl);
    }

    public ByProjectKeyCategoriesGet category(CategoryQuery queryDsl) {
        return QueryBuilder.query(this.apiRoot.categories().get(), queryDsl);
    }

    public ByProjectKeyChannelsGet channel(ChannelQuery queryDsl) {
        return QueryBuilder.query(this.apiRoot.channels().get(), queryDsl);
    }

    public ByProjectKeyProductsGet products(ProductQuery queryDsl) {
        return QueryBuilder.query(this.apiRoot.products().get(), queryDsl);
    }

    public ByProjectKeyProductProjectionsGet productProjections(ProductProjectionQuery queryDsl) {
        return QueryBuilder.query(this.apiRoot.productProjections().get(), queryDsl);
    }

    public ByProjectKeyCustomerGroupsGet customerGroups(CustomerGroupQuery queryDsl) {
        return QueryBuilder.query(this.apiRoot.customerGroups().get(), queryDsl);
    }

    public ByProjectKeyExtensionsGet extensions(ExtensionQuery queryDsl) {
        return QueryBuilder.query(this.apiRoot.extensions().get(), queryDsl);
    }

    public ByProjectKeyInventoryGet inventory(InventoryEntryQuery queryDsl) {
        return QueryBuilder.query(this.apiRoot.inventory().get(), queryDsl);
    }

    public ByProjectKeyMessagesGet messages(MessageQuery queryDsl) {
        return QueryBuilder.query(this.apiRoot.messages().get(), queryDsl);
    }

    public ByProjectKeyOrdersGet orders(OrderQuery queryDsl) {
        return QueryBuilder.query(this.apiRoot.orders().get(), queryDsl);
    }

    public ByProjectKeyPaymentsGet payments(PaymentQuery queryDsl) {
        return QueryBuilder.query(this.apiRoot.payments().get(), queryDsl);
    }

    public ByProjectKeyProductDiscountsGet productDiscounts(ProductDiscountQuery queryDsl) {
        return QueryBuilder.query(this.apiRoot.productDiscounts().get(), queryDsl);
    }

    public ByProjectKeyProductTypesGet productTypes(ProductTypeQuery queryDsl) {
        return QueryBuilder.query(this.apiRoot.productTypes().get(), queryDsl);
    }

    public ByProjectKeyReviewsGet review(ReviewQuery queryDsl) {
        return QueryBuilder.query(this.apiRoot.reviews().get(), queryDsl);
    }

    public ByProjectKeyShippingMethodsGet shippingMethods(ShippingMethodQuery queryDsl) {
        return QueryBuilder.query(this.apiRoot.shippingMethods().get(), queryDsl);
    }

    public ByProjectKeyShoppingListsGet shoppingLists(ShoppingListQuery queryDsl) {
        return QueryBuilder.query(this.apiRoot.shoppingLists().get(), queryDsl);
    }

    public ByProjectKeyStatesGet states(StateQuery queryDsl) {
        return QueryBuilder.query(this.apiRoot.states().get(), queryDsl);
    }

    public ByProjectKeyStoresGet stores(StoreQuery queryDsl) {
        return QueryBuilder.query(this.apiRoot.stores().get(), queryDsl);
    }

    public ByProjectKeySubscriptionsGet subscriptions(SubscriptionQuery queryDsl) {
        return QueryBuilder.query(this.apiRoot.subscriptions().get(), queryDsl);
    }

    public ByProjectKeyTaxCategoriesGet taxCategories(TaxCategoryQuery queryDsl) {
        return QueryBuilder.query(this.apiRoot.taxCategories().get(), queryDsl);
    }

    public ByProjectKeyZonesGet zones(ZoneQuery queryDsl) {
        return QueryBuilder.query(this.apiRoot.zones().get(), queryDsl);
    }

    public ByProjectKeyTypesGet types(TypeQuery queryDsl) {
        return QueryBuilder.query(this.apiRoot.types().get(), queryDsl);
    }
}

