
package com.commercetools.api.models.channel;

import java.time.*;
import java.util.*;
import java.util.function.Function;

import javax.validation.constraints.NotNull;

import com.fasterxml.jackson.annotation.*;
import com.fasterxml.jackson.databind.annotation.*;

import io.vrap.rmf.base.client.utils.Generated;

/**
 * ChannelRemoveRolesAction
 *
 * <hr>
 * Example to create an instance using the builder pattern
 * <div class=code-example>
 * <pre><code class='java'>
 *     ChannelRemoveRolesAction channelRemoveRolesAction = ChannelRemoveRolesAction.builder()
 *             .plusRoles(rolesBuilder -> rolesBuilder)
 *             .build()
 * </code></pre>
 * </div>
 */
@Generated(value = "io.vrap.rmf.codegen.rendering.CoreCodeGenerator", comments = "https://github.com/commercetools/rmf-codegen")
@JsonDeserialize(as = ChannelRemoveRolesActionImpl.class)
public interface ChannelRemoveRolesAction extends ChannelUpdateAction {

    String REMOVE_ROLES = "removeRoles";

    /**
     *  <p>Value to remove from the array.</p>
     */
    @NotNull
    @JsonProperty("roles")
    public List<ChannelRoleEnum> getRoles();

    @JsonIgnore
    public void setRoles(final ChannelRoleEnum... roles);

    public void setRoles(final List<ChannelRoleEnum> roles);

    public static ChannelRemoveRolesAction of() {
        return new ChannelRemoveRolesActionImpl();
    }

    public static ChannelRemoveRolesAction of(final ChannelRemoveRolesAction template) {
        ChannelRemoveRolesActionImpl instance = new ChannelRemoveRolesActionImpl();
        instance.setRoles(template.getRoles());
        return instance;
    }

    public static ChannelRemoveRolesActionBuilder builder() {
        return ChannelRemoveRolesActionBuilder.of();
    }

    public static ChannelRemoveRolesActionBuilder builder(final ChannelRemoveRolesAction template) {
        return ChannelRemoveRolesActionBuilder.of(template);
    }

    default <T> T withChannelRemoveRolesAction(Function<ChannelRemoveRolesAction, T> helper) {
        return helper.apply(this);
    }

    public static com.fasterxml.jackson.core.type.TypeReference<ChannelRemoveRolesAction> typeReference() {
        return new com.fasterxml.jackson.core.type.TypeReference<ChannelRemoveRolesAction>() {
            @Override
            public String toString() {
                return "TypeReference<ChannelRemoveRolesAction>";
            }
        };
    }
}
