
package com.commercetools.api.models.customer;

import java.time.*;
import java.util.*;
import java.util.function.Function;

import javax.validation.constraints.NotNull;

import com.fasterxml.jackson.annotation.*;
import com.fasterxml.jackson.databind.annotation.*;

import io.vrap.rmf.base.client.utils.Generated;

/**
 * CustomerEmailVerify
 *
 * <hr>
 * Example to create an instance using the builder pattern
 * <div class=code-example>
 * <pre><code class='java'>
 *     CustomerEmailVerify customerEmailVerify = CustomerEmailVerify.builder()
 *             .tokenValue("{tokenValue}")
 *             .build()
 * </code></pre>
 * </div>
 */
@Generated(value = "io.vrap.rmf.codegen.rendering.CoreCodeGenerator", comments = "https://github.com/commercetools/rmf-codegen")
@JsonDeserialize(as = CustomerEmailVerifyImpl.class)
public interface CustomerEmailVerify {

    /**
     *
     */

    @JsonProperty("version")
    public Long getVersion();

    /**
     *
     */
    @NotNull
    @JsonProperty("tokenValue")
    public String getTokenValue();

    public void setVersion(final Long version);

    public void setTokenValue(final String tokenValue);

    public static CustomerEmailVerify of() {
        return new CustomerEmailVerifyImpl();
    }

    public static CustomerEmailVerify of(final CustomerEmailVerify template) {
        CustomerEmailVerifyImpl instance = new CustomerEmailVerifyImpl();
        instance.setVersion(template.getVersion());
        instance.setTokenValue(template.getTokenValue());
        return instance;
    }

    public static CustomerEmailVerifyBuilder builder() {
        return CustomerEmailVerifyBuilder.of();
    }

    public static CustomerEmailVerifyBuilder builder(final CustomerEmailVerify template) {
        return CustomerEmailVerifyBuilder.of(template);
    }

    default <T> T withCustomerEmailVerify(Function<CustomerEmailVerify, T> helper) {
        return helper.apply(this);
    }

    public static com.fasterxml.jackson.core.type.TypeReference<CustomerEmailVerify> typeReference() {
        return new com.fasterxml.jackson.core.type.TypeReference<CustomerEmailVerify>() {
            @Override
            public String toString() {
                return "TypeReference<CustomerEmailVerify>";
            }
        };
    }
}
