
package com.commercetools.api.models.discount_code;

import java.time.*;
import java.util.*;
import java.util.function.Function;

import com.fasterxml.jackson.annotation.*;
import com.fasterxml.jackson.databind.annotation.*;

import io.vrap.rmf.base.client.utils.Generated;

/**
 * DiscountCodeSetMaxApplicationsPerCustomerAction
 *
 * <hr>
 * Example to create an instance using the builder pattern
 * <div class=code-example>
 * <pre><code class='java'>
 *     DiscountCodeSetMaxApplicationsPerCustomerAction discountCodeSetMaxApplicationsPerCustomerAction = DiscountCodeSetMaxApplicationsPerCustomerAction.builder()
 *             .build()
 * </code></pre>
 * </div>
 */
@Generated(value = "io.vrap.rmf.codegen.rendering.CoreCodeGenerator", comments = "https://github.com/commercetools/rmf-codegen")
@JsonDeserialize(as = DiscountCodeSetMaxApplicationsPerCustomerActionImpl.class)
public interface DiscountCodeSetMaxApplicationsPerCustomerAction extends DiscountCodeUpdateAction {

    String SET_MAX_APPLICATIONS_PER_CUSTOMER = "setMaxApplicationsPerCustomer";

    /**
     *  <p>Value to set. If empty, any existing value will be removed.</p>
     */

    @JsonProperty("maxApplicationsPerCustomer")
    public Long getMaxApplicationsPerCustomer();

    public void setMaxApplicationsPerCustomer(final Long maxApplicationsPerCustomer);

    public static DiscountCodeSetMaxApplicationsPerCustomerAction of() {
        return new DiscountCodeSetMaxApplicationsPerCustomerActionImpl();
    }

    public static DiscountCodeSetMaxApplicationsPerCustomerAction of(
            final DiscountCodeSetMaxApplicationsPerCustomerAction template) {
        DiscountCodeSetMaxApplicationsPerCustomerActionImpl instance = new DiscountCodeSetMaxApplicationsPerCustomerActionImpl();
        instance.setMaxApplicationsPerCustomer(template.getMaxApplicationsPerCustomer());
        return instance;
    }

    public static DiscountCodeSetMaxApplicationsPerCustomerActionBuilder builder() {
        return DiscountCodeSetMaxApplicationsPerCustomerActionBuilder.of();
    }

    public static DiscountCodeSetMaxApplicationsPerCustomerActionBuilder builder(
            final DiscountCodeSetMaxApplicationsPerCustomerAction template) {
        return DiscountCodeSetMaxApplicationsPerCustomerActionBuilder.of(template);
    }

    default <T> T withDiscountCodeSetMaxApplicationsPerCustomerAction(
            Function<DiscountCodeSetMaxApplicationsPerCustomerAction, T> helper) {
        return helper.apply(this);
    }

    public static com.fasterxml.jackson.core.type.TypeReference<DiscountCodeSetMaxApplicationsPerCustomerAction> typeReference() {
        return new com.fasterxml.jackson.core.type.TypeReference<DiscountCodeSetMaxApplicationsPerCustomerAction>() {
            @Override
            public String toString() {
                return "TypeReference<DiscountCodeSetMaxApplicationsPerCustomerAction>";
            }
        };
    }
}
