
package com.commercetools.api.models.me;

import java.time.*;
import java.util.*;
import java.util.function.Function;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;

import com.fasterxml.jackson.annotation.*;
import com.fasterxml.jackson.databind.annotation.*;

import io.vrap.rmf.base.client.utils.Generated;

/**
 * MyPaymentUpdate
 *
 * <hr>
 * Example to create an instance using the builder pattern
 * <div class=code-example>
 * <pre><code class='java'>
 *     MyPaymentUpdate myPaymentUpdate = MyPaymentUpdate.builder()
 *             .version(0.3)
 *             .plusActions(actionsBuilder -> actionsBuilder)
 *             .build()
 * </code></pre>
 * </div>
 */
@Generated(value = "io.vrap.rmf.codegen.rendering.CoreCodeGenerator", comments = "https://github.com/commercetools/rmf-codegen")
@JsonDeserialize(as = MyPaymentUpdateImpl.class)
public interface MyPaymentUpdate extends
        com.commercetools.api.models.ResourceUpdate<MyPaymentUpdate, MyPaymentUpdateAction, MyPaymentUpdateBuilder> {

    /**
     *
     */
    @NotNull
    @JsonProperty("version")
    public Long getVersion();

    /**
     *
     */
    @NotNull
    @Valid
    @JsonProperty("actions")
    public List<MyPaymentUpdateAction> getActions();

    public void setVersion(final Long version);

    @JsonIgnore
    public void setActions(final MyPaymentUpdateAction... actions);

    public void setActions(final List<MyPaymentUpdateAction> actions);

    public static MyPaymentUpdate of() {
        return new MyPaymentUpdateImpl();
    }

    public static MyPaymentUpdate of(final MyPaymentUpdate template) {
        MyPaymentUpdateImpl instance = new MyPaymentUpdateImpl();
        instance.setVersion(template.getVersion());
        instance.setActions(template.getActions());
        return instance;
    }

    public static MyPaymentUpdateBuilder builder() {
        return MyPaymentUpdateBuilder.of();
    }

    public static MyPaymentUpdateBuilder builder(final MyPaymentUpdate template) {
        return MyPaymentUpdateBuilder.of(template);
    }

    default <T> T withMyPaymentUpdate(Function<MyPaymentUpdate, T> helper) {
        return helper.apply(this);
    }

    public static com.fasterxml.jackson.core.type.TypeReference<MyPaymentUpdate> typeReference() {
        return new com.fasterxml.jackson.core.type.TypeReference<MyPaymentUpdate>() {
            @Override
            public String toString() {
                return "TypeReference<MyPaymentUpdate>";
            }
        };
    }
}
