
package com.commercetools.api.models.message;

import java.time.*;
import java.util.*;
import java.util.function.Function;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;

import com.commercetools.api.models.payment.Payment;
import com.fasterxml.jackson.annotation.*;
import com.fasterxml.jackson.databind.annotation.*;

import io.vrap.rmf.base.client.utils.Generated;

/**
 * PaymentCreatedMessagePayload
 *
 * <hr>
 * Example to create an instance using the builder pattern
 * <div class=code-example>
 * <pre><code class='java'>
 *     PaymentCreatedMessagePayload paymentCreatedMessagePayload = PaymentCreatedMessagePayload.builder()
 *             .payment(paymentBuilder -> paymentBuilder)
 *             .build()
 * </code></pre>
 * </div>
 */
@Generated(value = "io.vrap.rmf.codegen.rendering.CoreCodeGenerator", comments = "https://github.com/commercetools/rmf-codegen")
@JsonDeserialize(as = PaymentCreatedMessagePayloadImpl.class)
public interface PaymentCreatedMessagePayload extends MessagePayload {

    String PAYMENT_CREATED = "PaymentCreated";

    /**
     *
     */
    @NotNull
    @Valid
    @JsonProperty("payment")
    public Payment getPayment();

    public void setPayment(final Payment payment);

    public static PaymentCreatedMessagePayload of() {
        return new PaymentCreatedMessagePayloadImpl();
    }

    public static PaymentCreatedMessagePayload of(final PaymentCreatedMessagePayload template) {
        PaymentCreatedMessagePayloadImpl instance = new PaymentCreatedMessagePayloadImpl();
        instance.setPayment(template.getPayment());
        return instance;
    }

    public static PaymentCreatedMessagePayloadBuilder builder() {
        return PaymentCreatedMessagePayloadBuilder.of();
    }

    public static PaymentCreatedMessagePayloadBuilder builder(final PaymentCreatedMessagePayload template) {
        return PaymentCreatedMessagePayloadBuilder.of(template);
    }

    default <T> T withPaymentCreatedMessagePayload(Function<PaymentCreatedMessagePayload, T> helper) {
        return helper.apply(this);
    }

    public static com.fasterxml.jackson.core.type.TypeReference<PaymentCreatedMessagePayload> typeReference() {
        return new com.fasterxml.jackson.core.type.TypeReference<PaymentCreatedMessagePayload>() {
            @Override
            public String toString() {
                return "TypeReference<PaymentCreatedMessagePayload>";
            }
        };
    }
}
