
package com.commercetools.api.models.order_edit;

import java.time.*;
import java.util.*;
import java.util.function.Function;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;

import com.commercetools.api.models.order.StagedOrderUpdateAction;
import com.fasterxml.jackson.annotation.*;
import com.fasterxml.jackson.databind.annotation.*;

import io.vrap.rmf.base.client.utils.Generated;

/**
 * OrderEditAddStagedActionAction
 *
 * <hr>
 * Example to create an instance using the builder pattern
 * <div class=code-example>
 * <pre><code class='java'>
 *     OrderEditAddStagedActionAction orderEditAddStagedActionAction = OrderEditAddStagedActionAction.builder()
 *             .stagedAction(stagedActionBuilder -> stagedActionBuilder)
 *             .build()
 * </code></pre>
 * </div>
 */
@Generated(value = "io.vrap.rmf.codegen.rendering.CoreCodeGenerator", comments = "https://github.com/commercetools/rmf-codegen")
@JsonDeserialize(as = OrderEditAddStagedActionActionImpl.class)
public interface OrderEditAddStagedActionAction extends OrderEditUpdateAction {

    String ADD_STAGED_ACTION = "addStagedAction";

    /**
     *
     */
    @NotNull
    @Valid
    @JsonProperty("stagedAction")
    public StagedOrderUpdateAction getStagedAction();

    public void setStagedAction(final StagedOrderUpdateAction stagedAction);

    public static OrderEditAddStagedActionAction of() {
        return new OrderEditAddStagedActionActionImpl();
    }

    public static OrderEditAddStagedActionAction of(final OrderEditAddStagedActionAction template) {
        OrderEditAddStagedActionActionImpl instance = new OrderEditAddStagedActionActionImpl();
        instance.setStagedAction(template.getStagedAction());
        return instance;
    }

    public static OrderEditAddStagedActionActionBuilder builder() {
        return OrderEditAddStagedActionActionBuilder.of();
    }

    public static OrderEditAddStagedActionActionBuilder builder(final OrderEditAddStagedActionAction template) {
        return OrderEditAddStagedActionActionBuilder.of(template);
    }

    default <T> T withOrderEditAddStagedActionAction(Function<OrderEditAddStagedActionAction, T> helper) {
        return helper.apply(this);
    }

    public static com.fasterxml.jackson.core.type.TypeReference<OrderEditAddStagedActionAction> typeReference() {
        return new com.fasterxml.jackson.core.type.TypeReference<OrderEditAddStagedActionAction>() {
            @Override
            public String toString() {
                return "TypeReference<OrderEditAddStagedActionAction>";
            }
        };
    }
}
