
package com.commercetools.api.models.order_edit;

import java.time.*;
import java.util.*;
import java.util.function.Function;

import com.commercetools.api.models.order.ShipmentState;
import com.commercetools.api.models.order.StagedOrderUpdateAction;
import com.fasterxml.jackson.annotation.*;
import com.fasterxml.jackson.databind.annotation.*;

import io.vrap.rmf.base.client.utils.Generated;

/**
 * StagedOrderChangeShipmentStateAction
 *
 * <hr>
 * Example to create an instance using the builder pattern
 * <div class=code-example>
 * <pre><code class='java'>
 *     StagedOrderChangeShipmentStateAction stagedOrderChangeShipmentStateAction = StagedOrderChangeShipmentStateAction.builder()
 *             .build()
 * </code></pre>
 * </div>
 */
@Generated(value = "io.vrap.rmf.codegen.rendering.CoreCodeGenerator", comments = "https://github.com/commercetools/rmf-codegen")
@JsonDeserialize(as = StagedOrderChangeShipmentStateActionImpl.class)
public interface StagedOrderChangeShipmentStateAction extends StagedOrderUpdateAction {

    String CHANGE_SHIPMENT_STATE = "changeShipmentState";

    /**
     *
     */

    @JsonProperty("shipmentState")
    public ShipmentState getShipmentState();

    public void setShipmentState(final ShipmentState shipmentState);

    public static StagedOrderChangeShipmentStateAction of() {
        return new StagedOrderChangeShipmentStateActionImpl();
    }

    public static StagedOrderChangeShipmentStateAction of(final StagedOrderChangeShipmentStateAction template) {
        StagedOrderChangeShipmentStateActionImpl instance = new StagedOrderChangeShipmentStateActionImpl();
        instance.setShipmentState(template.getShipmentState());
        return instance;
    }

    public static StagedOrderChangeShipmentStateActionBuilder builder() {
        return StagedOrderChangeShipmentStateActionBuilder.of();
    }

    public static StagedOrderChangeShipmentStateActionBuilder builder(
            final StagedOrderChangeShipmentStateAction template) {
        return StagedOrderChangeShipmentStateActionBuilder.of(template);
    }

    default <T> T withStagedOrderChangeShipmentStateAction(Function<StagedOrderChangeShipmentStateAction, T> helper) {
        return helper.apply(this);
    }

    public static com.fasterxml.jackson.core.type.TypeReference<StagedOrderChangeShipmentStateAction> typeReference() {
        return new com.fasterxml.jackson.core.type.TypeReference<StagedOrderChangeShipmentStateAction>() {
            @Override
            public String toString() {
                return "TypeReference<StagedOrderChangeShipmentStateAction>";
            }
        };
    }
}
