
package com.commercetools.api.models.product;

import java.time.*;
import java.util.*;
import java.util.function.Function;

import com.commercetools.api.models.cart.ProductPublishScope;
import com.fasterxml.jackson.annotation.*;
import com.fasterxml.jackson.databind.annotation.*;

import io.vrap.rmf.base.client.utils.Generated;

/**
 * ProductPublishAction
 *
 * <hr>
 * Example to create an instance using the builder pattern
 * <div class=code-example>
 * <pre><code class='java'>
 *     ProductPublishAction productPublishAction = ProductPublishAction.builder()
 *             .build()
 * </code></pre>
 * </div>
 */
@Generated(value = "io.vrap.rmf.codegen.rendering.CoreCodeGenerator", comments = "https://github.com/commercetools/rmf-codegen")
@JsonDeserialize(as = ProductPublishActionImpl.class)
public interface ProductPublishAction extends ProductUpdateAction {

    String PUBLISH = "publish";

    /**
     *
     */

    @JsonProperty("scope")
    public ProductPublishScope getScope();

    public void setScope(final ProductPublishScope scope);

    public static ProductPublishAction of() {
        return new ProductPublishActionImpl();
    }

    public static ProductPublishAction of(final ProductPublishAction template) {
        ProductPublishActionImpl instance = new ProductPublishActionImpl();
        instance.setScope(template.getScope());
        return instance;
    }

    public static ProductPublishActionBuilder builder() {
        return ProductPublishActionBuilder.of();
    }

    public static ProductPublishActionBuilder builder(final ProductPublishAction template) {
        return ProductPublishActionBuilder.of(template);
    }

    default <T> T withProductPublishAction(Function<ProductPublishAction, T> helper) {
        return helper.apply(this);
    }

    public static com.fasterxml.jackson.core.type.TypeReference<ProductPublishAction> typeReference() {
        return new com.fasterxml.jackson.core.type.TypeReference<ProductPublishAction>() {
            @Override
            public String toString() {
                return "TypeReference<ProductPublishAction>";
            }
        };
    }
}
