
package com.commercetools.api.models.product;

import java.time.*;
import java.util.*;
import java.util.function.Function;

import javax.validation.constraints.NotNull;

import com.fasterxml.jackson.annotation.*;
import com.fasterxml.jackson.databind.annotation.*;

import io.vrap.rmf.base.client.utils.Generated;

/**
 * Suggestion
 *
 * <hr>
 * Example to create an instance using the builder pattern
 * <div class=code-example>
 * <pre><code class='java'>
 *     Suggestion suggestion = Suggestion.builder()
 *             .text("{text}")
 *             .build()
 * </code></pre>
 * </div>
 */
@Generated(value = "io.vrap.rmf.codegen.rendering.CoreCodeGenerator", comments = "https://github.com/commercetools/rmf-codegen")
@JsonDeserialize(as = SuggestionImpl.class)
public interface Suggestion {

    /**
     *  <p>The suggested text.</p>
     */
    @NotNull
    @JsonProperty("text")
    public String getText();

    public void setText(final String text);

    public static Suggestion of() {
        return new SuggestionImpl();
    }

    public static Suggestion of(final Suggestion template) {
        SuggestionImpl instance = new SuggestionImpl();
        instance.setText(template.getText());
        return instance;
    }

    public static SuggestionBuilder builder() {
        return SuggestionBuilder.of();
    }

    public static SuggestionBuilder builder(final Suggestion template) {
        return SuggestionBuilder.of(template);
    }

    default <T> T withSuggestion(Function<Suggestion, T> helper) {
        return helper.apply(this);
    }

    public static com.fasterxml.jackson.core.type.TypeReference<Suggestion> typeReference() {
        return new com.fasterxml.jackson.core.type.TypeReference<Suggestion>() {
            @Override
            public String toString() {
                return "TypeReference<Suggestion>";
            }
        };
    }
}
