
package com.commercetools.api.models.product;

import java.time.*;
import java.util.*;
import java.util.function.Function;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;

import com.fasterxml.jackson.annotation.*;
import com.fasterxml.jackson.databind.annotation.*;

import io.vrap.rmf.base.client.utils.Generated;

/**
 * TermFacetResult
 *
 * <hr>
 * Example to create an instance using the builder pattern
 * <div class=code-example>
 * <pre><code class='java'>
 *     TermFacetResult termFacetResult = TermFacetResult.builder()
 *             .dataType(TermFacetResultType.TEXT)
 *             .missing(0.3)
 *             .total(0.3)
 *             .other(0.3)
 *             .plusTerms(termsBuilder -> termsBuilder)
 *             .build()
 * </code></pre>
 * </div>
 */
@Generated(value = "io.vrap.rmf.codegen.rendering.CoreCodeGenerator", comments = "https://github.com/commercetools/rmf-codegen")
@JsonDeserialize(as = TermFacetResultImpl.class)
public interface TermFacetResult extends FacetResult {

    String TERMS = "terms";

    /**
     *
     */
    @NotNull
    @JsonProperty("dataType")
    public TermFacetResultType getDataType();

    /**
     *
     */
    @NotNull
    @JsonProperty("missing")
    public Long getMissing();

    /**
     *
     */
    @NotNull
    @JsonProperty("total")
    public Long getTotal();

    /**
     *
     */
    @NotNull
    @JsonProperty("other")
    public Long getOther();

    /**
     *
     */
    @NotNull
    @Valid
    @JsonProperty("terms")
    public List<FacetTerm> getTerms();

    public void setDataType(final TermFacetResultType dataType);

    public void setMissing(final Long missing);

    public void setTotal(final Long total);

    public void setOther(final Long other);

    @JsonIgnore
    public void setTerms(final FacetTerm... terms);

    public void setTerms(final List<FacetTerm> terms);

    public static TermFacetResult of() {
        return new TermFacetResultImpl();
    }

    public static TermFacetResult of(final TermFacetResult template) {
        TermFacetResultImpl instance = new TermFacetResultImpl();
        instance.setDataType(template.getDataType());
        instance.setMissing(template.getMissing());
        instance.setTotal(template.getTotal());
        instance.setOther(template.getOther());
        instance.setTerms(template.getTerms());
        return instance;
    }

    public static TermFacetResultBuilder builder() {
        return TermFacetResultBuilder.of();
    }

    public static TermFacetResultBuilder builder(final TermFacetResult template) {
        return TermFacetResultBuilder.of(template);
    }

    default <T> T withTermFacetResult(Function<TermFacetResult, T> helper) {
        return helper.apply(this);
    }

    public static com.fasterxml.jackson.core.type.TypeReference<TermFacetResult> typeReference() {
        return new com.fasterxml.jackson.core.type.TypeReference<TermFacetResult>() {
            @Override
            public String toString() {
                return "TypeReference<TermFacetResult>";
            }
        };
    }
}
