
package com.commercetools.api.models.state;

import java.time.*;
import java.util.*;
import java.util.function.Function;

import javax.validation.constraints.NotNull;

import com.fasterxml.jackson.annotation.*;
import com.fasterxml.jackson.databind.annotation.*;

import io.vrap.rmf.base.client.utils.Generated;

/**
 * StateRemoveRolesAction
 *
 * <hr>
 * Example to create an instance using the builder pattern
 * <div class=code-example>
 * <pre><code class='java'>
 *     StateRemoveRolesAction stateRemoveRolesAction = StateRemoveRolesAction.builder()
 *             .plusRoles(rolesBuilder -> rolesBuilder)
 *             .build()
 * </code></pre>
 * </div>
 */
@Generated(value = "io.vrap.rmf.codegen.rendering.CoreCodeGenerator", comments = "https://github.com/commercetools/rmf-codegen")
@JsonDeserialize(as = StateRemoveRolesActionImpl.class)
public interface StateRemoveRolesAction extends StateUpdateAction {

    String REMOVE_ROLES = "removeRoles";

    /**
     *  <p>Roles to remove from the State.</p>
     */
    @NotNull
    @JsonProperty("roles")
    public List<StateRoleEnum> getRoles();

    @JsonIgnore
    public void setRoles(final StateRoleEnum... roles);

    public void setRoles(final List<StateRoleEnum> roles);

    public static StateRemoveRolesAction of() {
        return new StateRemoveRolesActionImpl();
    }

    public static StateRemoveRolesAction of(final StateRemoveRolesAction template) {
        StateRemoveRolesActionImpl instance = new StateRemoveRolesActionImpl();
        instance.setRoles(template.getRoles());
        return instance;
    }

    public static StateRemoveRolesActionBuilder builder() {
        return StateRemoveRolesActionBuilder.of();
    }

    public static StateRemoveRolesActionBuilder builder(final StateRemoveRolesAction template) {
        return StateRemoveRolesActionBuilder.of(template);
    }

    default <T> T withStateRemoveRolesAction(Function<StateRemoveRolesAction, T> helper) {
        return helper.apply(this);
    }

    public static com.fasterxml.jackson.core.type.TypeReference<StateRemoveRolesAction> typeReference() {
        return new com.fasterxml.jackson.core.type.TypeReference<StateRemoveRolesAction>() {
            @Override
            public String toString() {
                return "TypeReference<StateRemoveRolesAction>";
            }
        };
    }
}
