
package com.commercetools.api.models.tax_category;

import java.time.*;
import java.util.*;
import java.util.function.Function;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;

import com.fasterxml.jackson.annotation.*;
import com.fasterxml.jackson.databind.annotation.*;

import io.vrap.rmf.base.client.utils.Generated;

/**
 * TaxCategoryReplaceTaxRateAction
 *
 * <hr>
 * Example to create an instance using the builder pattern
 * <div class=code-example>
 * <pre><code class='java'>
 *     TaxCategoryReplaceTaxRateAction taxCategoryReplaceTaxRateAction = TaxCategoryReplaceTaxRateAction.builder()
 *             .taxRateId("{taxRateId}")
 *             .taxRate(taxRateBuilder -> taxRateBuilder)
 *             .build()
 * </code></pre>
 * </div>
 */
@Generated(value = "io.vrap.rmf.codegen.rendering.CoreCodeGenerator", comments = "https://github.com/commercetools/rmf-codegen")
@JsonDeserialize(as = TaxCategoryReplaceTaxRateActionImpl.class)
public interface TaxCategoryReplaceTaxRateAction extends TaxCategoryUpdateAction {

    String REPLACE_TAX_RATE = "replaceTaxRate";

    /**
     *  <p>ID of the TaxRate to replace.</p>
     */
    @NotNull
    @JsonProperty("taxRateId")
    public String getTaxRateId();

    /**
     *  <p>New TaxRate to replace with.</p>
     */
    @NotNull
    @Valid
    @JsonProperty("taxRate")
    public TaxRateDraft getTaxRate();

    public void setTaxRateId(final String taxRateId);

    public void setTaxRate(final TaxRateDraft taxRate);

    public static TaxCategoryReplaceTaxRateAction of() {
        return new TaxCategoryReplaceTaxRateActionImpl();
    }

    public static TaxCategoryReplaceTaxRateAction of(final TaxCategoryReplaceTaxRateAction template) {
        TaxCategoryReplaceTaxRateActionImpl instance = new TaxCategoryReplaceTaxRateActionImpl();
        instance.setTaxRateId(template.getTaxRateId());
        instance.setTaxRate(template.getTaxRate());
        return instance;
    }

    public static TaxCategoryReplaceTaxRateActionBuilder builder() {
        return TaxCategoryReplaceTaxRateActionBuilder.of();
    }

    public static TaxCategoryReplaceTaxRateActionBuilder builder(final TaxCategoryReplaceTaxRateAction template) {
        return TaxCategoryReplaceTaxRateActionBuilder.of(template);
    }

    default <T> T withTaxCategoryReplaceTaxRateAction(Function<TaxCategoryReplaceTaxRateAction, T> helper) {
        return helper.apply(this);
    }

    public static com.fasterxml.jackson.core.type.TypeReference<TaxCategoryReplaceTaxRateAction> typeReference() {
        return new com.fasterxml.jackson.core.type.TypeReference<TaxCategoryReplaceTaxRateAction>() {
            @Override
            public String toString() {
                return "TypeReference<TaxCategoryReplaceTaxRateAction>";
            }
        };
    }
}
