/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.history.models.common;

import com.commercetools.history.models.common.DeliveryItem;
import com.commercetools.history.models.common.DeliveryItemBuilder;
import com.commercetools.history.models.common.Parcel;
import com.commercetools.history.models.common.ParcelImpl;
import com.commercetools.history.models.common.ParcelMeasurements;
import com.commercetools.history.models.common.ParcelMeasurementsBuilder;
import com.commercetools.history.models.common.TrackingData;
import com.commercetools.history.models.common.TrackingDataBuilder;
import io.vrap.rmf.base.client.Builder;
import io.vrap.rmf.base.client.utils.Generated;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@Generated(value="io.vrap.rmf.codegen.rendering.CoreCodeGenerator", comments="https://github.com/commercetools/rmf-codegen")
public class ParcelBuilder
implements Builder<Parcel> {
    private String id;
    private String createdAt;
    private ParcelMeasurements measurements;
    private TrackingData trackingData;
    private List<DeliveryItem> items;

    public ParcelBuilder id(String id) {
        this.id = id;
        return this;
    }

    public ParcelBuilder createdAt(String createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    public ParcelBuilder measurements(Function<ParcelMeasurementsBuilder, ParcelMeasurementsBuilder> builder) {
        this.measurements = builder.apply(ParcelMeasurementsBuilder.of()).build();
        return this;
    }

    public ParcelBuilder measurements(ParcelMeasurements measurements) {
        this.measurements = measurements;
        return this;
    }

    public ParcelBuilder trackingData(Function<TrackingDataBuilder, TrackingDataBuilder> builder) {
        this.trackingData = builder.apply(TrackingDataBuilder.of()).build();
        return this;
    }

    public ParcelBuilder trackingData(TrackingData trackingData) {
        this.trackingData = trackingData;
        return this;
    }

    public ParcelBuilder items(DeliveryItem ... items) {
        this.items = new ArrayList<DeliveryItem>(Arrays.asList(items));
        return this;
    }

    public ParcelBuilder items(List<DeliveryItem> items) {
        this.items = items;
        return this;
    }

    public ParcelBuilder plusItems(DeliveryItem ... items) {
        if (this.items == null) {
            this.items = new ArrayList<DeliveryItem>();
        }
        this.items.addAll(Arrays.asList(items));
        return this;
    }

    public ParcelBuilder plusItems(Function<DeliveryItemBuilder, DeliveryItemBuilder> builder) {
        if (this.items == null) {
            this.items = new ArrayList<DeliveryItem>();
        }
        this.items.add(builder.apply(DeliveryItemBuilder.of()).build());
        return this;
    }

    public ParcelBuilder withItems(Function<DeliveryItemBuilder, DeliveryItemBuilder> builder) {
        this.items = new ArrayList<DeliveryItem>();
        this.items.add(builder.apply(DeliveryItemBuilder.of()).build());
        return this;
    }

    public String getId() {
        return this.id;
    }

    public String getCreatedAt() {
        return this.createdAt;
    }

    public ParcelMeasurements getMeasurements() {
        return this.measurements;
    }

    public TrackingData getTrackingData() {
        return this.trackingData;
    }

    public List<DeliveryItem> getItems() {
        return this.items;
    }

    public Parcel build() {
        Objects.requireNonNull(this.id, Parcel.class + ": id is missing");
        Objects.requireNonNull(this.createdAt, Parcel.class + ": createdAt is missing");
        Objects.requireNonNull(this.measurements, Parcel.class + ": measurements is missing");
        Objects.requireNonNull(this.trackingData, Parcel.class + ": trackingData is missing");
        Objects.requireNonNull(this.items, Parcel.class + ": items is missing");
        return new ParcelImpl(this.id, this.createdAt, this.measurements, this.trackingData, this.items);
    }

    public Parcel buildUnchecked() {
        return new ParcelImpl(this.id, this.createdAt, this.measurements, this.trackingData, this.items);
    }

    public static ParcelBuilder of() {
        return new ParcelBuilder();
    }

    public static ParcelBuilder of(Parcel template) {
        ParcelBuilder builder = new ParcelBuilder();
        builder.id = template.getId();
        builder.createdAt = template.getCreatedAt();
        builder.measurements = template.getMeasurements();
        builder.trackingData = template.getTrackingData();
        builder.items = template.getItems();
        return builder;
    }
}

