/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.history.models.common;

import com.commercetools.history.models.common.Reference;
import com.commercetools.history.models.common.ReferenceBuilder;
import com.commercetools.history.models.common.Reservation;
import com.commercetools.history.models.common.ReservationImpl;
import io.vrap.rmf.base.client.Builder;
import io.vrap.rmf.base.client.utils.Generated;
import java.util.Objects;
import java.util.function.Function;

@Generated(value="io.vrap.rmf.codegen.rendering.CoreCodeGenerator", comments="https://github.com/commercetools/rmf-codegen")
public class ReservationBuilder
implements Builder<Reservation> {
    private Integer quantity;
    private Reference owner;
    private String createdAt;
    private String checkoutStartedAt;

    public ReservationBuilder quantity(Integer quantity) {
        this.quantity = quantity;
        return this;
    }

    public ReservationBuilder owner(Function<ReferenceBuilder, ReferenceBuilder> builder) {
        this.owner = builder.apply(ReferenceBuilder.of()).build();
        return this;
    }

    public ReservationBuilder owner(Reference owner) {
        this.owner = owner;
        return this;
    }

    public ReservationBuilder createdAt(String createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    public ReservationBuilder checkoutStartedAt(String checkoutStartedAt) {
        this.checkoutStartedAt = checkoutStartedAt;
        return this;
    }

    public Integer getQuantity() {
        return this.quantity;
    }

    public Reference getOwner() {
        return this.owner;
    }

    public String getCreatedAt() {
        return this.createdAt;
    }

    public String getCheckoutStartedAt() {
        return this.checkoutStartedAt;
    }

    public Reservation build() {
        Objects.requireNonNull(this.quantity, Reservation.class + ": quantity is missing");
        Objects.requireNonNull(this.owner, Reservation.class + ": owner is missing");
        Objects.requireNonNull(this.createdAt, Reservation.class + ": createdAt is missing");
        Objects.requireNonNull(this.checkoutStartedAt, Reservation.class + ": checkoutStartedAt is missing");
        return new ReservationImpl(this.quantity, this.owner, this.createdAt, this.checkoutStartedAt);
    }

    public Reservation buildUnchecked() {
        return new ReservationImpl(this.quantity, this.owner, this.createdAt, this.checkoutStartedAt);
    }

    public static ReservationBuilder of() {
        return new ReservationBuilder();
    }

    public static ReservationBuilder of(Reservation template) {
        ReservationBuilder builder = new ReservationBuilder();
        builder.quantity = template.getQuantity();
        builder.owner = template.getOwner();
        builder.createdAt = template.getCreatedAt();
        builder.checkoutStartedAt = template.getCheckoutStartedAt();
        return builder;
    }
}

