/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.history.models.common;

import com.commercetools.history.models.common.Money;
import com.commercetools.history.models.common.MoneyBuilder;
import com.commercetools.history.models.common.TaxedPrice;
import com.commercetools.history.models.common.TaxedPriceImpl;
import io.vrap.rmf.base.client.Builder;
import io.vrap.rmf.base.client.utils.Generated;
import java.util.Objects;
import java.util.function.Function;

@Generated(value="io.vrap.rmf.codegen.rendering.CoreCodeGenerator", comments="https://github.com/commercetools/rmf-codegen")
public class TaxedPriceBuilder
implements Builder<TaxedPrice> {
    private Money totalNet;
    private Money totalGross;

    public TaxedPriceBuilder totalNet(Function<MoneyBuilder, MoneyBuilder> builder) {
        this.totalNet = builder.apply(MoneyBuilder.of()).build();
        return this;
    }

    public TaxedPriceBuilder totalNet(Money totalNet) {
        this.totalNet = totalNet;
        return this;
    }

    public TaxedPriceBuilder totalGross(Function<MoneyBuilder, MoneyBuilder> builder) {
        this.totalGross = builder.apply(MoneyBuilder.of()).build();
        return this;
    }

    public TaxedPriceBuilder totalGross(Money totalGross) {
        this.totalGross = totalGross;
        return this;
    }

    public Money getTotalNet() {
        return this.totalNet;
    }

    public Money getTotalGross() {
        return this.totalGross;
    }

    public TaxedPrice build() {
        Objects.requireNonNull(this.totalNet, TaxedPrice.class + ": totalNet is missing");
        Objects.requireNonNull(this.totalGross, TaxedPrice.class + ": totalGross is missing");
        return new TaxedPriceImpl(this.totalNet, this.totalGross);
    }

    public TaxedPrice buildUnchecked() {
        return new TaxedPriceImpl(this.totalNet, this.totalGross);
    }

    public static TaxedPriceBuilder of() {
        return new TaxedPriceBuilder();
    }

    public static TaxedPriceBuilder of(TaxedPrice template) {
        TaxedPriceBuilder builder = new TaxedPriceBuilder();
        builder.totalNet = template.getTotalNet();
        builder.totalGross = template.getTotalGross();
        return builder;
    }
}

