/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.history.models.common;

import com.commercetools.history.models.common.Money;
import com.commercetools.history.models.common.MoneyBuilder;
import com.commercetools.history.models.common.ShippingRate;
import com.commercetools.history.models.common.ShippingRateImpl;
import com.commercetools.history.models.common.ShippingRatePriceTier;
import com.commercetools.history.models.common.ShippingRatePriceTierBuilder;
import io.vrap.rmf.base.client.Builder;
import io.vrap.rmf.base.client.utils.Generated;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@Generated(value="io.vrap.rmf.codegen.rendering.CoreCodeGenerator", comments="https://github.com/commercetools/rmf-codegen")
public class ShippingRateBuilder
implements Builder<ShippingRate> {
    private Money price;
    private Money freeAbove;
    private Boolean isMatching;
    private List<ShippingRatePriceTier> tiers;

    public ShippingRateBuilder price(Function<MoneyBuilder, MoneyBuilder> builder) {
        this.price = builder.apply(MoneyBuilder.of()).build();
        return this;
    }

    public ShippingRateBuilder withPrice(Function<MoneyBuilder, Money> builder) {
        this.price = builder.apply(MoneyBuilder.of());
        return this;
    }

    public ShippingRateBuilder price(Money price) {
        this.price = price;
        return this;
    }

    public ShippingRateBuilder freeAbove(Function<MoneyBuilder, MoneyBuilder> builder) {
        this.freeAbove = builder.apply(MoneyBuilder.of()).build();
        return this;
    }

    public ShippingRateBuilder withFreeAbove(Function<MoneyBuilder, Money> builder) {
        this.freeAbove = builder.apply(MoneyBuilder.of());
        return this;
    }

    public ShippingRateBuilder freeAbove(Money freeAbove) {
        this.freeAbove = freeAbove;
        return this;
    }

    public ShippingRateBuilder isMatching(Boolean isMatching) {
        this.isMatching = isMatching;
        return this;
    }

    public ShippingRateBuilder tiers(ShippingRatePriceTier ... tiers) {
        this.tiers = new ArrayList<ShippingRatePriceTier>(Arrays.asList(tiers));
        return this;
    }

    public ShippingRateBuilder tiers(List<ShippingRatePriceTier> tiers) {
        this.tiers = tiers;
        return this;
    }

    public ShippingRateBuilder plusTiers(ShippingRatePriceTier ... tiers) {
        if (this.tiers == null) {
            this.tiers = new ArrayList<ShippingRatePriceTier>();
        }
        this.tiers.addAll(Arrays.asList(tiers));
        return this;
    }

    public ShippingRateBuilder plusTiers(Function<ShippingRatePriceTierBuilder, ShippingRatePriceTierBuilder> builder) {
        if (this.tiers == null) {
            this.tiers = new ArrayList<ShippingRatePriceTier>();
        }
        this.tiers.add(builder.apply(ShippingRatePriceTierBuilder.of()).build());
        return this;
    }

    public ShippingRateBuilder withTiers(Function<ShippingRatePriceTierBuilder, ShippingRatePriceTierBuilder> builder) {
        this.tiers = new ArrayList<ShippingRatePriceTier>();
        this.tiers.add(builder.apply(ShippingRatePriceTierBuilder.of()).build());
        return this;
    }

    public ShippingRateBuilder addTiers(Function<ShippingRatePriceTierBuilder, ShippingRatePriceTier> builder) {
        return this.plusTiers(builder.apply(ShippingRatePriceTierBuilder.of()));
    }

    public ShippingRateBuilder setTiers(Function<ShippingRatePriceTierBuilder, ShippingRatePriceTier> builder) {
        return this.tiers(builder.apply(ShippingRatePriceTierBuilder.of()));
    }

    public Money getPrice() {
        return this.price;
    }

    public Money getFreeAbove() {
        return this.freeAbove;
    }

    public Boolean getIsMatching() {
        return this.isMatching;
    }

    public List<ShippingRatePriceTier> getTiers() {
        return this.tiers;
    }

    public ShippingRate build() {
        Objects.requireNonNull(this.price, ShippingRate.class + ": price is missing");
        Objects.requireNonNull(this.freeAbove, ShippingRate.class + ": freeAbove is missing");
        Objects.requireNonNull(this.isMatching, ShippingRate.class + ": isMatching is missing");
        Objects.requireNonNull(this.tiers, ShippingRate.class + ": tiers is missing");
        return new ShippingRateImpl(this.price, this.freeAbove, this.isMatching, this.tiers);
    }

    public ShippingRate buildUnchecked() {
        return new ShippingRateImpl(this.price, this.freeAbove, this.isMatching, this.tiers);
    }

    public static ShippingRateBuilder of() {
        return new ShippingRateBuilder();
    }

    public static ShippingRateBuilder of(ShippingRate template) {
        ShippingRateBuilder builder = new ShippingRateBuilder();
        builder.price = template.getPrice();
        builder.freeAbove = template.getFreeAbove();
        builder.isMatching = template.getIsMatching();
        builder.tiers = template.getTiers();
        return builder;
    }
}

