/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.history.models.common;

import com.commercetools.history.models.common.Address;
import com.commercetools.history.models.common.CustomFields;
import com.commercetools.history.models.common.DeliveryBuilder;
import com.commercetools.history.models.common.DeliveryImpl;
import com.commercetools.history.models.common.DeliveryItem;
import com.commercetools.history.models.common.Parcel;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.vrap.rmf.base.client.utils.Generated;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@Generated(value="io.vrap.rmf.codegen.rendering.CoreCodeGenerator", comments="https://github.com/commercetools/rmf-codegen")
@JsonDeserialize(as=DeliveryImpl.class)
public interface Delivery {
    @NotNull
    @JsonProperty(value="id")
    public String getId();

    @NotNull
    @JsonProperty(value="createdAt")
    public String getCreatedAt();

    @NotNull
    @Valid
    @JsonProperty(value="items")
    public List<DeliveryItem> getItems();

    @NotNull
    @Valid
    @JsonProperty(value="parcels")
    public List<Parcel> getParcels();

    @Valid
    @JsonProperty(value="address")
    public Address getAddress();

    @Valid
    @JsonProperty(value="custom")
    public CustomFields getCustom();

    public void setId(String var1);

    public void setCreatedAt(String var1);

    @JsonIgnore
    public void setItems(DeliveryItem ... var1);

    public void setItems(List<DeliveryItem> var1);

    @JsonIgnore
    public void setParcels(Parcel ... var1);

    public void setParcels(List<Parcel> var1);

    public void setAddress(Address var1);

    public void setCustom(CustomFields var1);

    public static Delivery of() {
        return new DeliveryImpl();
    }

    public static Delivery of(Delivery template) {
        DeliveryImpl instance = new DeliveryImpl();
        instance.setId(template.getId());
        instance.setCreatedAt(template.getCreatedAt());
        instance.setItems(template.getItems());
        instance.setParcels(template.getParcels());
        instance.setAddress(template.getAddress());
        instance.setCustom(template.getCustom());
        return instance;
    }

    @Nullable
    public static Delivery deepCopy(@Nullable Delivery template) {
        if (template == null) {
            return null;
        }
        DeliveryImpl instance = new DeliveryImpl();
        instance.setId(template.getId());
        instance.setCreatedAt(template.getCreatedAt());
        instance.setItems((List<DeliveryItem>)Optional.ofNullable(template.getItems()).map(t -> t.stream().map(DeliveryItem::deepCopy).collect(Collectors.toList())).orElse(null));
        instance.setParcels((List<Parcel>)Optional.ofNullable(template.getParcels()).map(t -> t.stream().map(Parcel::deepCopy).collect(Collectors.toList())).orElse(null));
        instance.setAddress(Address.deepCopy(template.getAddress()));
        instance.setCustom(CustomFields.deepCopy(template.getCustom()));
        return instance;
    }

    public static DeliveryBuilder builder() {
        return DeliveryBuilder.of();
    }

    public static DeliveryBuilder builder(Delivery template) {
        return DeliveryBuilder.of(template);
    }

    default public <T> T withDelivery(Function<Delivery, T> helper) {
        return helper.apply(this);
    }

    public static TypeReference<Delivery> typeReference() {
        return new TypeReference<Delivery>(){

            public String toString() {
                return "TypeReference<Delivery>";
            }
        };
    }
}

