/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.history.models.common;

import com.commercetools.history.models.common.DeliveryItem;
import com.commercetools.history.models.common.ParcelBuilder;
import com.commercetools.history.models.common.ParcelImpl;
import com.commercetools.history.models.common.ParcelMeasurements;
import com.commercetools.history.models.common.TrackingData;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.vrap.rmf.base.client.utils.Generated;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@Generated(value="io.vrap.rmf.codegen.rendering.CoreCodeGenerator", comments="https://github.com/commercetools/rmf-codegen")
@JsonDeserialize(as=ParcelImpl.class)
public interface Parcel {
    @NotNull
    @JsonProperty(value="id")
    public String getId();

    @NotNull
    @JsonProperty(value="createdAt")
    public String getCreatedAt();

    @NotNull
    @Valid
    @JsonProperty(value="measurements")
    public ParcelMeasurements getMeasurements();

    @NotNull
    @Valid
    @JsonProperty(value="trackingData")
    public TrackingData getTrackingData();

    @NotNull
    @Valid
    @JsonProperty(value="items")
    public List<DeliveryItem> getItems();

    public void setId(String var1);

    public void setCreatedAt(String var1);

    public void setMeasurements(ParcelMeasurements var1);

    public void setTrackingData(TrackingData var1);

    @JsonIgnore
    public void setItems(DeliveryItem ... var1);

    public void setItems(List<DeliveryItem> var1);

    public static Parcel of() {
        return new ParcelImpl();
    }

    public static Parcel of(Parcel template) {
        ParcelImpl instance = new ParcelImpl();
        instance.setId(template.getId());
        instance.setCreatedAt(template.getCreatedAt());
        instance.setMeasurements(template.getMeasurements());
        instance.setTrackingData(template.getTrackingData());
        instance.setItems(template.getItems());
        return instance;
    }

    @Nullable
    public static Parcel deepCopy(@Nullable Parcel template) {
        if (template == null) {
            return null;
        }
        ParcelImpl instance = new ParcelImpl();
        instance.setId(template.getId());
        instance.setCreatedAt(template.getCreatedAt());
        instance.setMeasurements(ParcelMeasurements.deepCopy(template.getMeasurements()));
        instance.setTrackingData(TrackingData.deepCopy(template.getTrackingData()));
        instance.setItems((List<DeliveryItem>)Optional.ofNullable(template.getItems()).map(t -> t.stream().map(DeliveryItem::deepCopy).collect(Collectors.toList())).orElse(null));
        return instance;
    }

    public static ParcelBuilder builder() {
        return ParcelBuilder.of();
    }

    public static ParcelBuilder builder(Parcel template) {
        return ParcelBuilder.of(template);
    }

    default public <T> T withParcel(Function<Parcel, T> helper) {
        return helper.apply(this);
    }

    public static TypeReference<Parcel> typeReference() {
        return new TypeReference<Parcel>(){

            public String toString() {
                return "TypeReference<Parcel>";
            }
        };
    }
}

