/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.history.client;

import com.commercetools.history.client.ApiRoot;
import com.commercetools.history.client.ByProjectKeyByResourceTypeRequestBuilder;
import com.commercetools.history.client.ByProjectKeyGet;
import com.commercetools.history.client.ByProjectKeyGraphqlRequestBuilder;
import com.commercetools.history.client.ByProjectKeyRequestBuilder;
import com.commercetools.history.client.ProjectScopedApiRoot;
import io.vrap.rmf.base.client.ApiHttpClient;
import io.vrap.rmf.base.client.SerializerOnlyApiHttpClient;
import java.io.Closeable;

public class ProjectApiRoot
implements Closeable,
ProjectScopedApiRoot {
    private final String projectKey;
    private final ApiHttpClient apiHttpClient;

    private ProjectApiRoot(String projectKey, ApiHttpClient apiHttpClient) {
        this.projectKey = projectKey;
        this.apiHttpClient = apiHttpClient;
    }

    public static ProjectApiRoot of(String projectKey) {
        return new ProjectApiRoot(projectKey, (ApiHttpClient)SerializerOnlyApiHttpClient.of());
    }

    public static ProjectApiRoot fromClient(String projectKey, ApiHttpClient apiHttpClient) {
        return new ProjectApiRoot(projectKey, apiHttpClient);
    }

    @Override
    public ByProjectKeyRequestBuilder with() {
        return ApiRoot.fromClient(this.apiHttpClient).withProjectKeyValue(this.projectKey);
    }

    public ByProjectKeyRequestBuilder withProjectKey(String projectKey) {
        return ApiRoot.fromClient(this.apiHttpClient).withProjectKeyValue(projectKey);
    }

    @Override
    public ByProjectKeyGet get() {
        return this.with().get();
    }

    @Override
    public ByProjectKeyByResourceTypeRequestBuilder withResourceTypeValue(String resourceType) {
        return this.with().withResourceTypeValue(resourceType);
    }

    @Override
    public ByProjectKeyGraphqlRequestBuilder graphql() {
        return this.with().graphql();
    }

    @Override
    public void close() {
        if (this.apiHttpClient == null) {
            return;
        }
        try {
            this.apiHttpClient.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

