/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.history.models.common;

import com.commercetools.history.models.common.Asset;
import com.commercetools.history.models.common.AssetImpl;
import com.commercetools.history.models.common.CustomFields;
import com.commercetools.history.models.common.CustomFieldsBuilder;
import com.commercetools.history.models.common.LocalizedString;
import com.commercetools.history.models.common.LocalizedStringBuilder;
import io.vrap.rmf.base.client.Builder;
import io.vrap.rmf.base.client.utils.Generated;
import java.util.Objects;
import java.util.function.Function;

@Generated(value="io.vrap.rmf.codegen.rendering.CoreCodeGenerator", comments="https://github.com/commercetools/rmf-codegen")
public class AssetBuilder
implements Builder<Asset> {
    private String id;
    private LocalizedString name;
    private LocalizedString description;
    private CustomFields custom;
    private String key;

    public AssetBuilder id(String id) {
        this.id = id;
        return this;
    }

    public AssetBuilder name(Function<LocalizedStringBuilder, LocalizedStringBuilder> builder) {
        this.name = builder.apply(LocalizedStringBuilder.of()).build();
        return this;
    }

    public AssetBuilder withName(Function<LocalizedStringBuilder, LocalizedString> builder) {
        this.name = builder.apply(LocalizedStringBuilder.of());
        return this;
    }

    public AssetBuilder name(LocalizedString name) {
        this.name = name;
        return this;
    }

    public AssetBuilder description(Function<LocalizedStringBuilder, LocalizedStringBuilder> builder) {
        this.description = builder.apply(LocalizedStringBuilder.of()).build();
        return this;
    }

    public AssetBuilder withDescription(Function<LocalizedStringBuilder, LocalizedString> builder) {
        this.description = builder.apply(LocalizedStringBuilder.of());
        return this;
    }

    public AssetBuilder description(LocalizedString description) {
        this.description = description;
        return this;
    }

    public AssetBuilder custom(Function<CustomFieldsBuilder, CustomFieldsBuilder> builder) {
        this.custom = builder.apply(CustomFieldsBuilder.of()).build();
        return this;
    }

    public AssetBuilder withCustom(Function<CustomFieldsBuilder, CustomFields> builder) {
        this.custom = builder.apply(CustomFieldsBuilder.of());
        return this;
    }

    public AssetBuilder custom(CustomFields custom) {
        this.custom = custom;
        return this;
    }

    public AssetBuilder key(String key) {
        this.key = key;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public LocalizedString getName() {
        return this.name;
    }

    public LocalizedString getDescription() {
        return this.description;
    }

    public CustomFields getCustom() {
        return this.custom;
    }

    public String getKey() {
        return this.key;
    }

    public Asset build() {
        Objects.requireNonNull(this.id, Asset.class + ": id is missing");
        Objects.requireNonNull(this.name, Asset.class + ": name is missing");
        Objects.requireNonNull(this.description, Asset.class + ": description is missing");
        Objects.requireNonNull(this.custom, Asset.class + ": custom is missing");
        Objects.requireNonNull(this.key, Asset.class + ": key is missing");
        return new AssetImpl(this.id, this.name, this.description, this.custom, this.key);
    }

    public Asset buildUnchecked() {
        return new AssetImpl(this.id, this.name, this.description, this.custom, this.key);
    }

    public static AssetBuilder of() {
        return new AssetBuilder();
    }

    public static AssetBuilder of(Asset template) {
        AssetBuilder builder = new AssetBuilder();
        builder.id = template.getId();
        builder.name = template.getName();
        builder.description = template.getDescription();
        builder.custom = template.getCustom();
        builder.key = template.getKey();
        return builder;
    }
}

