/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.history.models.common;

import com.commercetools.history.models.common.CustomLineItem;
import com.commercetools.history.models.common.CustomLineItemImpl;
import com.commercetools.history.models.common.LocalizedString;
import com.commercetools.history.models.common.LocalizedStringBuilder;
import com.commercetools.history.models.common.Money;
import com.commercetools.history.models.common.MoneyBuilder;
import com.commercetools.history.models.common.TaxedItemPrice;
import com.commercetools.history.models.common.TaxedItemPriceBuilder;
import io.vrap.rmf.base.client.Builder;
import io.vrap.rmf.base.client.utils.Generated;
import java.util.Objects;
import java.util.function.Function;

@Generated(value="io.vrap.rmf.codegen.rendering.CoreCodeGenerator", comments="https://github.com/commercetools/rmf-codegen")
public class CustomLineItemBuilder
implements Builder<CustomLineItem> {
    private String id;
    private LocalizedString name;
    private Money money;
    private TaxedItemPrice taxedPrice;
    private Money totalPrice;
    private String slug;
    private Integer quantity;

    public CustomLineItemBuilder id(String id) {
        this.id = id;
        return this;
    }

    public CustomLineItemBuilder name(Function<LocalizedStringBuilder, LocalizedStringBuilder> builder) {
        this.name = builder.apply(LocalizedStringBuilder.of()).build();
        return this;
    }

    public CustomLineItemBuilder withName(Function<LocalizedStringBuilder, LocalizedString> builder) {
        this.name = builder.apply(LocalizedStringBuilder.of());
        return this;
    }

    public CustomLineItemBuilder name(LocalizedString name) {
        this.name = name;
        return this;
    }

    public CustomLineItemBuilder money(Function<MoneyBuilder, MoneyBuilder> builder) {
        this.money = builder.apply(MoneyBuilder.of()).build();
        return this;
    }

    public CustomLineItemBuilder withMoney(Function<MoneyBuilder, Money> builder) {
        this.money = builder.apply(MoneyBuilder.of());
        return this;
    }

    public CustomLineItemBuilder money(Money money) {
        this.money = money;
        return this;
    }

    public CustomLineItemBuilder taxedPrice(Function<TaxedItemPriceBuilder, TaxedItemPriceBuilder> builder) {
        this.taxedPrice = builder.apply(TaxedItemPriceBuilder.of()).build();
        return this;
    }

    public CustomLineItemBuilder withTaxedPrice(Function<TaxedItemPriceBuilder, TaxedItemPrice> builder) {
        this.taxedPrice = builder.apply(TaxedItemPriceBuilder.of());
        return this;
    }

    public CustomLineItemBuilder taxedPrice(TaxedItemPrice taxedPrice) {
        this.taxedPrice = taxedPrice;
        return this;
    }

    public CustomLineItemBuilder totalPrice(Function<MoneyBuilder, MoneyBuilder> builder) {
        this.totalPrice = builder.apply(MoneyBuilder.of()).build();
        return this;
    }

    public CustomLineItemBuilder withTotalPrice(Function<MoneyBuilder, Money> builder) {
        this.totalPrice = builder.apply(MoneyBuilder.of());
        return this;
    }

    public CustomLineItemBuilder totalPrice(Money totalPrice) {
        this.totalPrice = totalPrice;
        return this;
    }

    public CustomLineItemBuilder slug(String slug) {
        this.slug = slug;
        return this;
    }

    public CustomLineItemBuilder quantity(Integer quantity) {
        this.quantity = quantity;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public LocalizedString getName() {
        return this.name;
    }

    public Money getMoney() {
        return this.money;
    }

    public TaxedItemPrice getTaxedPrice() {
        return this.taxedPrice;
    }

    public Money getTotalPrice() {
        return this.totalPrice;
    }

    public String getSlug() {
        return this.slug;
    }

    public Integer getQuantity() {
        return this.quantity;
    }

    public CustomLineItem build() {
        Objects.requireNonNull(this.id, CustomLineItem.class + ": id is missing");
        Objects.requireNonNull(this.name, CustomLineItem.class + ": name is missing");
        Objects.requireNonNull(this.money, CustomLineItem.class + ": money is missing");
        Objects.requireNonNull(this.taxedPrice, CustomLineItem.class + ": taxedPrice is missing");
        Objects.requireNonNull(this.totalPrice, CustomLineItem.class + ": totalPrice is missing");
        Objects.requireNonNull(this.slug, CustomLineItem.class + ": slug is missing");
        Objects.requireNonNull(this.quantity, CustomLineItem.class + ": quantity is missing");
        return new CustomLineItemImpl(this.id, this.name, this.money, this.taxedPrice, this.totalPrice, this.slug, this.quantity);
    }

    public CustomLineItem buildUnchecked() {
        return new CustomLineItemImpl(this.id, this.name, this.money, this.taxedPrice, this.totalPrice, this.slug, this.quantity);
    }

    public static CustomLineItemBuilder of() {
        return new CustomLineItemBuilder();
    }

    public static CustomLineItemBuilder of(CustomLineItem template) {
        CustomLineItemBuilder builder = new CustomLineItemBuilder();
        builder.id = template.getId();
        builder.name = template.getName();
        builder.money = template.getMoney();
        builder.taxedPrice = template.getTaxedPrice();
        builder.totalPrice = template.getTotalPrice();
        builder.slug = template.getSlug();
        builder.quantity = template.getQuantity();
        return builder;
    }
}

