/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.history.models.common;

import com.commercetools.history.models.common.SubRate;
import com.commercetools.history.models.common.TaxRateBuilder;
import com.commercetools.history.models.common.TaxRateImpl;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.vrap.rmf.base.client.utils.Generated;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@Generated(value="io.vrap.rmf.codegen.rendering.CoreCodeGenerator", comments="https://github.com/commercetools/rmf-codegen")
@JsonDeserialize(as=TaxRateImpl.class)
public interface TaxRate {
    @NotNull
    @JsonProperty(value="id")
    public String getId();

    @NotNull
    @JsonProperty(value="name")
    public String getName();

    @NotNull
    @JsonProperty(value="amount")
    public Integer getAmount();

    @NotNull
    @JsonProperty(value="includedInPrice")
    public Boolean getIncludedInPrice();

    @NotNull
    @JsonProperty(value="country")
    public String getCountry();

    @NotNull
    @JsonProperty(value="state")
    public String getState();

    @NotNull
    @Valid
    @JsonProperty(value="subRates")
    public List<SubRate> getSubRates();

    public void setId(String var1);

    public void setName(String var1);

    public void setAmount(Integer var1);

    public void setIncludedInPrice(Boolean var1);

    public void setCountry(String var1);

    public void setState(String var1);

    @JsonIgnore
    public void setSubRates(SubRate ... var1);

    public void setSubRates(List<SubRate> var1);

    public static TaxRate of() {
        return new TaxRateImpl();
    }

    public static TaxRate of(TaxRate template) {
        TaxRateImpl instance = new TaxRateImpl();
        instance.setId(template.getId());
        instance.setName(template.getName());
        instance.setAmount(template.getAmount());
        instance.setIncludedInPrice(template.getIncludedInPrice());
        instance.setCountry(template.getCountry());
        instance.setState(template.getState());
        instance.setSubRates(template.getSubRates());
        return instance;
    }

    @Nullable
    public static TaxRate deepCopy(@Nullable TaxRate template) {
        if (template == null) {
            return null;
        }
        TaxRateImpl instance = new TaxRateImpl();
        instance.setId(template.getId());
        instance.setName(template.getName());
        instance.setAmount(template.getAmount());
        instance.setIncludedInPrice(template.getIncludedInPrice());
        instance.setCountry(template.getCountry());
        instance.setState(template.getState());
        instance.setSubRates((List<SubRate>)Optional.ofNullable(template.getSubRates()).map(t -> t.stream().map(SubRate::deepCopy).collect(Collectors.toList())).orElse(null));
        return instance;
    }

    public static TaxRateBuilder builder() {
        return TaxRateBuilder.of();
    }

    public static TaxRateBuilder builder(TaxRate template) {
        return TaxRateBuilder.of(template);
    }

    default public <T> T withTaxRate(Function<TaxRate, T> helper) {
        return helper.apply(this);
    }

    public static TypeReference<TaxRate> typeReference() {
        return new TypeReference<TaxRate>(){

            public String toString() {
                return "TypeReference<TaxRate>";
            }
        };
    }
}

