/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.history.models.common;

import com.commercetools.history.models.common.SubRate;
import com.commercetools.history.models.common.SubRateBuilder;
import com.commercetools.history.models.common.TaxRate;
import com.commercetools.history.models.common.TaxRateImpl;
import io.vrap.rmf.base.client.Builder;
import io.vrap.rmf.base.client.utils.Generated;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@Generated(value="io.vrap.rmf.codegen.rendering.CoreCodeGenerator", comments="https://github.com/commercetools/rmf-codegen")
public class TaxRateBuilder
implements Builder<TaxRate> {
    private String id;
    private String name;
    private Integer amount;
    private Boolean includedInPrice;
    private String country;
    private String state;
    private List<SubRate> subRates;

    public TaxRateBuilder id(String id) {
        this.id = id;
        return this;
    }

    public TaxRateBuilder name(String name) {
        this.name = name;
        return this;
    }

    public TaxRateBuilder amount(Integer amount) {
        this.amount = amount;
        return this;
    }

    public TaxRateBuilder includedInPrice(Boolean includedInPrice) {
        this.includedInPrice = includedInPrice;
        return this;
    }

    public TaxRateBuilder country(String country) {
        this.country = country;
        return this;
    }

    public TaxRateBuilder state(String state) {
        this.state = state;
        return this;
    }

    public TaxRateBuilder subRates(SubRate ... subRates) {
        this.subRates = new ArrayList<SubRate>(Arrays.asList(subRates));
        return this;
    }

    public TaxRateBuilder subRates(List<SubRate> subRates) {
        this.subRates = subRates;
        return this;
    }

    public TaxRateBuilder plusSubRates(SubRate ... subRates) {
        if (this.subRates == null) {
            this.subRates = new ArrayList<SubRate>();
        }
        this.subRates.addAll(Arrays.asList(subRates));
        return this;
    }

    public TaxRateBuilder plusSubRates(Function<SubRateBuilder, SubRateBuilder> builder) {
        if (this.subRates == null) {
            this.subRates = new ArrayList<SubRate>();
        }
        this.subRates.add(builder.apply(SubRateBuilder.of()).build());
        return this;
    }

    public TaxRateBuilder withSubRates(Function<SubRateBuilder, SubRateBuilder> builder) {
        this.subRates = new ArrayList<SubRate>();
        this.subRates.add(builder.apply(SubRateBuilder.of()).build());
        return this;
    }

    public TaxRateBuilder addSubRates(Function<SubRateBuilder, SubRate> builder) {
        return this.plusSubRates(builder.apply(SubRateBuilder.of()));
    }

    public TaxRateBuilder setSubRates(Function<SubRateBuilder, SubRate> builder) {
        return this.subRates(builder.apply(SubRateBuilder.of()));
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Integer getAmount() {
        return this.amount;
    }

    public Boolean getIncludedInPrice() {
        return this.includedInPrice;
    }

    public String getCountry() {
        return this.country;
    }

    public String getState() {
        return this.state;
    }

    public List<SubRate> getSubRates() {
        return this.subRates;
    }

    public TaxRate build() {
        Objects.requireNonNull(this.id, TaxRate.class + ": id is missing");
        Objects.requireNonNull(this.name, TaxRate.class + ": name is missing");
        Objects.requireNonNull(this.amount, TaxRate.class + ": amount is missing");
        Objects.requireNonNull(this.includedInPrice, TaxRate.class + ": includedInPrice is missing");
        Objects.requireNonNull(this.country, TaxRate.class + ": country is missing");
        Objects.requireNonNull(this.state, TaxRate.class + ": state is missing");
        Objects.requireNonNull(this.subRates, TaxRate.class + ": subRates is missing");
        return new TaxRateImpl(this.id, this.name, this.amount, this.includedInPrice, this.country, this.state, this.subRates);
    }

    public TaxRate buildUnchecked() {
        return new TaxRateImpl(this.id, this.name, this.amount, this.includedInPrice, this.country, this.state, this.subRates);
    }

    public static TaxRateBuilder of() {
        return new TaxRateBuilder();
    }

    public static TaxRateBuilder of(TaxRate template) {
        TaxRateBuilder builder = new TaxRateBuilder();
        builder.id = template.getId();
        builder.name = template.getName();
        builder.amount = template.getAmount();
        builder.includedInPrice = template.getIncludedInPrice();
        builder.country = template.getCountry();
        builder.state = template.getState();
        builder.subRates = template.getSubRates();
        return builder;
    }
}

