/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.history.models.change_value;

import com.commercetools.history.models.change_value.DeliveryChangeValue;
import com.commercetools.history.models.change_value.DeliveryChangeValueImpl;
import com.commercetools.history.models.common.Address;
import com.commercetools.history.models.common.AddressBuilder;
import com.commercetools.history.models.common.DeliveryItem;
import com.commercetools.history.models.common.DeliveryItemBuilder;
import com.commercetools.history.models.common.Parcel;
import com.commercetools.history.models.common.ParcelBuilder;
import io.vrap.rmf.base.client.Builder;
import io.vrap.rmf.base.client.utils.Generated;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@Generated(value="io.vrap.rmf.codegen.rendering.CoreCodeGenerator", comments="https://github.com/commercetools/rmf-codegen")
public class DeliveryChangeValueBuilder
implements Builder<DeliveryChangeValue> {
    private List<DeliveryItem> items;
    private Address address;
    private List<Parcel> parcels;

    public DeliveryChangeValueBuilder items(DeliveryItem ... items) {
        this.items = new ArrayList<DeliveryItem>(Arrays.asList(items));
        return this;
    }

    public DeliveryChangeValueBuilder items(List<DeliveryItem> items) {
        this.items = items;
        return this;
    }

    public DeliveryChangeValueBuilder plusItems(DeliveryItem ... items) {
        if (this.items == null) {
            this.items = new ArrayList<DeliveryItem>();
        }
        this.items.addAll(Arrays.asList(items));
        return this;
    }

    public DeliveryChangeValueBuilder plusItems(Function<DeliveryItemBuilder, DeliveryItemBuilder> builder) {
        if (this.items == null) {
            this.items = new ArrayList<DeliveryItem>();
        }
        this.items.add(builder.apply(DeliveryItemBuilder.of()).build());
        return this;
    }

    public DeliveryChangeValueBuilder withItems(Function<DeliveryItemBuilder, DeliveryItemBuilder> builder) {
        this.items = new ArrayList<DeliveryItem>();
        this.items.add(builder.apply(DeliveryItemBuilder.of()).build());
        return this;
    }

    public DeliveryChangeValueBuilder address(Function<AddressBuilder, AddressBuilder> builder) {
        this.address = builder.apply(AddressBuilder.of()).build();
        return this;
    }

    public DeliveryChangeValueBuilder address(Address address) {
        this.address = address;
        return this;
    }

    public DeliveryChangeValueBuilder parcels(Parcel ... parcels) {
        this.parcels = new ArrayList<Parcel>(Arrays.asList(parcels));
        return this;
    }

    public DeliveryChangeValueBuilder parcels(List<Parcel> parcels) {
        this.parcels = parcels;
        return this;
    }

    public DeliveryChangeValueBuilder plusParcels(Parcel ... parcels) {
        if (this.parcels == null) {
            this.parcels = new ArrayList<Parcel>();
        }
        this.parcels.addAll(Arrays.asList(parcels));
        return this;
    }

    public DeliveryChangeValueBuilder plusParcels(Function<ParcelBuilder, ParcelBuilder> builder) {
        if (this.parcels == null) {
            this.parcels = new ArrayList<Parcel>();
        }
        this.parcels.add(builder.apply(ParcelBuilder.of()).build());
        return this;
    }

    public DeliveryChangeValueBuilder withParcels(Function<ParcelBuilder, ParcelBuilder> builder) {
        this.parcels = new ArrayList<Parcel>();
        this.parcels.add(builder.apply(ParcelBuilder.of()).build());
        return this;
    }

    public List<DeliveryItem> getItems() {
        return this.items;
    }

    public Address getAddress() {
        return this.address;
    }

    public List<Parcel> getParcels() {
        return this.parcels;
    }

    public DeliveryChangeValue build() {
        Objects.requireNonNull(this.items, DeliveryChangeValue.class + ": items is missing");
        Objects.requireNonNull(this.address, DeliveryChangeValue.class + ": address is missing");
        Objects.requireNonNull(this.parcels, DeliveryChangeValue.class + ": parcels is missing");
        return new DeliveryChangeValueImpl(this.items, this.address, this.parcels);
    }

    public DeliveryChangeValue buildUnchecked() {
        return new DeliveryChangeValueImpl(this.items, this.address, this.parcels);
    }

    public static DeliveryChangeValueBuilder of() {
        return new DeliveryChangeValueBuilder();
    }

    public static DeliveryChangeValueBuilder of(DeliveryChangeValue template) {
        DeliveryChangeValueBuilder builder = new DeliveryChangeValueBuilder();
        builder.items = template.getItems();
        builder.address = template.getAddress();
        builder.parcels = template.getParcels();
        return builder;
    }
}

